package slimeknights.tconstruct.tools.debug;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;

import java.util.LinkedList;
import java.util.List;

import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.tools.ToolCore;

public class TempToolCrafting implements IRecipe {

  static {
    // register the recipe with the recipesorter
    RecipeSorter.register("tcon:tool", TempToolCrafting.class, RecipeSorter.Category.SHAPELESS, "");
  }

  private ItemStack outputTool;

  @Override
  public ItemStack func_77572_b(InventoryCrafting p_77572_1_) {
    return outputTool;
  }

  @Override
  public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
    outputTool = null;


    List<ItemStack> input = new LinkedList<ItemStack>();

    for(int i = 0; i < inv.func_70302_i_(); i++) {
      ItemStack slot = inv.func_70301_a(i);
      // empty slot
      if(slot == null) {
        continue;
      }

      // save it
      input.add(slot);
    }

    ItemStack[] inputs = input.toArray(new ItemStack[input.size()]);
    for(ToolCore tool : TinkerRegistry.getTools()) {
      outputTool = tool.buildItemFromStacks(inputs);
      if(outputTool != null) {
        break;
      }
    }

    return outputTool != null;
  }

  @Override
  public int func_77570_a() {
    return 2;
  }

  @Override
  public ItemStack func_77571_b() {
    return outputTool;
  }

  @Override
  public ItemStack[] func_179532_b(InventoryCrafting inv) {
    return new ItemStack[0];
  }
}
