package slimeknights.tconstruct.tools.client.module;

import com.google.common.collect.Lists;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;

import java.util.List;

import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.client.gui.GuiWidgetTabs;
import slimeknights.tconstruct.tools.client.GuiTinkerStation;

public class GuiTinkerTabs extends GuiModule {
  protected static final GuiElement GUI_Tab = new GuiElement(0,2,28,28,256,256);
  protected static final GuiElement GUI_TabActiveL = new GuiElement(0,32,28,32,256,256);
  protected static final GuiElement GUI_TabActiveC = new GuiElement(28,32,28,32,256,256);
  protected static final GuiElement GUI_TabActiveR = new GuiElement(140,32,28,32,256,256);

  public GuiWidgetTabs tabs;
  public List<BlockPos> tabData;

  public final GuiTinkerStation parent;

  public GuiTinkerTabs(GuiTinkerStation parent, Container container) {
    super(parent, container, false, false);

    this.parent = parent;

    this.field_146999_f = GUI_TabActiveC.w;
    this.field_147000_g = GUI_TabActiveC.h;

    this.tabs = new GuiWidgetTabs(parent, GUI_Tab, GUI_Tab, GUI_Tab, GUI_TabActiveL, GUI_TabActiveC, GUI_TabActiveR);
    this.tabData = Lists.newArrayList();
  }

  public void addTab(ItemStack icon, BlockPos data) {
    this.tabData.add(data);
    this.tabs.addTab(icon);
  }

  @Override
  public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
    super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);

    // we actually want to be on top of the parent
    this.field_147003_i = parentX;
    this.field_147009_r = parentY - this.field_147000_g;

    tabs.setPosition(field_147003_i + 4, field_147009_r);
  }

  @Override
  protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
    int sel = tabs.selected;
    tabs.update(mouseX, mouseY);
    tabs.draw();

    // new selection
    if(sel != tabs.selected) {
      parent.onTabSelection(tabs.selected);
    }
  }

  @Override
  protected void func_146979_b(int mouseX, int mouseY) {
    // highlighted tooltip
    if(tabs.highlighted > -1) {
      BlockPos pos = tabData.get(tabs.highlighted);
      IBlockState state = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_180495_p(pos);
      ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
      String name = stack.func_82833_r();

      // the origin has been translated to the top left of this gui rather than the screen, so we have to adjust
      func_146283_a(Lists.newArrayList(name), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
    }
  }
}
