package slimeknights.tconstruct.shared.worldgen;

import net.minecraft.block.state.pattern.BlockHelper;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

import java.util.Random;

import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockOre;

public class NetherOreGenerator implements IWorldGenerator {

  public static NetherOreGenerator INSTANCE = new NetherOreGenerator();

  public WorldGenMinable cobaltGen;
  public WorldGenMinable arditeGen;

  public NetherOreGenerator() {
    cobaltGen = new WorldGenMinable(TinkerCommons.blockOre.func_176203_a(BlockOre.OreTypes.COBALT.getMeta()),
                                    3,
                                    BlockHelper.func_177642_a(Blocks.field_150424_aL));

    arditeGen = new WorldGenMinable(TinkerCommons.blockOre.func_176203_a(BlockOre.OreTypes.ARDITE.getMeta()),
                                    3,
                                    BlockHelper.func_177642_a(Blocks.field_150424_aL));
  }

  @Override
  public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
    if(chunkGenerator instanceof ChunkProviderHell) {
      if(Config.genArdite) {
        generateNetherOre(arditeGen, Config.arditeRate, random, chunkX, chunkZ, world);
      }
      if(Config.genCobalt) {
        generateNetherOre(cobaltGen, Config.cobaltRate, random, chunkX, chunkZ, world);
      }
    }
  }

  public void generateNetherOre(WorldGenMinable gen, int rate, Random random, int chunkX, int chunkZ, World world) {
    BlockPos pos;
    for (int i = 0; i < rate; i += 2) {
      pos = new BlockPos(chunkX*16, 32, chunkZ*16);
      pos = pos.func_177982_a(random.nextInt(16), random.nextInt(64), random.nextInt(16));
      gen.func_180709_b(world, random, pos);

      pos = new BlockPos(chunkX*16, 0, chunkZ*16);
      pos = pos.func_177982_a(random.nextInt(16), random.nextInt(128), random.nextInt(16));
      gen.func_180709_b(world, random, pos);
    }
  }
}
