package slimeknights.tconstruct.shared.block;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.util.IStringSerializable;

import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;

public class BlockFirewood extends EnumBlock<BlockFirewood.FirewoodType> {

  public final static PropertyEnum<FirewoodType> TYPE = PropertyEnum.func_177709_a("type", FirewoodType.class);

  public BlockFirewood() {
    super(Material.field_151578_c, TYPE, FirewoodType.class);

    this.func_149711_c(2f);
    this.func_149752_b(7f);
    this.func_149647_a(TinkerRegistry.tabGeneral);
    this.func_149715_a(0.5f);
    func_149672_a(field_149766_f);

    this.setHarvestLevel("axe", -1);
  }

  public enum FirewoodType implements IStringSerializable, EnumBlock.IEnumMeta {
    LAVAWOOD,
    FIREWOOD;

    public final int meta;

    FirewoodType() {
      meta = ordinal();
    }

    @Override
    public String func_176610_l() {
      return this.toString();
    }

    @Override
    public int getMeta() {
      return meta;
    }
  }
}
