package slimeknights.tconstruct.library.client.texture;

import com.google.common.collect.Lists;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.RenderUtil;

public abstract class AbstractColoredTexture extends TextureAtlasSprite {

  private TextureAtlasSprite baseTexture;
  private String backupTextureLocation;
  private String extra;

  protected AbstractColoredTexture(TextureAtlasSprite baseTexture, String spriteName) {
    super(spriteName);
    this.baseTexture = baseTexture;
    this.backupTextureLocation = baseTexture.func_94215_i();
  }

  protected AbstractColoredTexture(String baseTextureLocation, String spriteName) {
    super(spriteName);

    this.baseTexture = null;
    this.backupTextureLocation = baseTextureLocation;
  }

  public TextureAtlasSprite setSuffix(String suffix) {
    this.extra = suffix;
    this.baseTexture = null;
    return this;
  }

  @Override
  public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
    return true;
  }

  @Override
  public boolean load(IResourceManager manager, ResourceLocation location) {
    this.field_110976_a = Lists.newArrayList();
    this.field_110973_g = 0;
    this.field_110983_h = 0;

    // get the base texture to work on
    int[][] data;
    // basetexture is present and loaded
    if(baseTexture != null && baseTexture.func_110970_k() > 0) {
      this.func_94217_a(baseTexture);
      int[][] original = baseTexture.func_147965_a(0);
      data = new int[original.length][];
      for(int i = 0; i < original.length; i++) {
        if(original[i] != null) {
          data[i] = Arrays.copyOf(original[i], original[i].length);
        }
      }
    }
    // load texture manually
    else {
      data = null;
      if(extra != null && !extra.isEmpty()) {
        data = backupLoadTexture(new ResourceLocation(backupTextureLocation + "_" + extra), manager);
      }
      if(data == null) {
        data = backupLoadTexture(new ResourceLocation(backupTextureLocation), manager);
      }
    }

    processData(data);

    if(this.field_110976_a.isEmpty()) {
      this.field_110976_a.add(data);
    }

    return false;
  }

  protected void processData(int[][] data) {
    // go over the base texture and color it
    for(int mipmap = 0; mipmap < data.length; mipmap++) {
      if(data[mipmap] == null) {
        continue;
      }
      for(int pxCoord = 0; pxCoord < data[mipmap].length; pxCoord++) {
        // we're not working per pixel
        // we take the information in the base texture to calculate the luminosity of the pixel
        // and then color it accordingly with the materials color
        data[mipmap][pxCoord] = colorPixel(data[mipmap][pxCoord], mipmap, pxCoord);
      }
    }
  }

  protected abstract int colorPixel(int pixel, int mipmap, int pxCoord);

  // loads the base texture manually, same procedure as TextureMap.
  // Be careful, this changes the width and height of the current texture. Be sure to preserve it if needed!
  protected int[][] backupLoadTexture(ResourceLocation resourceLocation, IResourceManager resourceManager) {
    if(resourceLocation.equals(TextureMap.field_174945_f)) {
      return Minecraft.func_71410_x().func_147117_R().func_174944_f().func_147965_a(0);
    }

    ResourceLocation resourcelocation1 = this.completeResourceLocation(resourceLocation, 0);

    try {
      IResource iresource = resourceManager.func_110536_a(resourcelocation1);
      BufferedImage[] abufferedimage = new BufferedImage[1 + 4];
      abufferedimage[0] = TextureUtil.func_177053_a(iresource.func_110527_b());

      this.field_130223_c = abufferedimage[0].getWidth();
      this.field_130224_d = abufferedimage[0].getHeight();

      int[][] aint = new int[abufferedimage.length][];
      for(int k = 0; k < abufferedimage.length; ++k) {
        BufferedImage bufferedimage = abufferedimage[k];

        if(bufferedimage != null) {
          aint[k] = new int[bufferedimage.getWidth() * bufferedimage.getHeight()];
          bufferedimage
              .getRGB(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight(), aint[k], 0, bufferedimage.getWidth());
        }
      }

      return aint;
    } catch(RuntimeException runtimeexception) {
      TinkerRegistry.log.error("Unable to parse metadata from " + resourcelocation1, runtimeexception);
    } catch(IOException ioexception1) {
      TinkerRegistry.log.error("Unable to generate " + this.func_94215_i() + ": unable to load " + resourcelocation1 + "!\nBase texture: " + baseTexture.func_94215_i(), ioexception1);
    }

    return null;
  }

  // completely emulates the behaviour of the TextureMap texture loading process
  protected TextureAtlasSprite backupLoadtextureAtlasSprite(ResourceLocation resourceLocation, IResourceManager resourceManager) {
    ResourceLocation resourcelocation1 = this.completeResourceLocation(resourceLocation, 0);
    TextureAtlasSprite textureAtlasSprite = TextureAtlasSprite.func_176604_a(resourceLocation);

    try {
      IResource iresource = resourceManager.func_110536_a(resourcelocation1);
      BufferedImage[] abufferedimage = new BufferedImage[1 + 4]; // iirc TextureMap.mipmapLevels is always 4? :I
      abufferedimage[0] = TextureUtil.func_177053_a(iresource.func_110527_b());
      TextureMetadataSection texturemetadatasection = (TextureMetadataSection) iresource.func_110526_a("texture");

      // metadata
      if(texturemetadatasection != null) {
        List<Integer> list = texturemetadatasection.func_148535_c();
        int i1;

        if(!list.isEmpty()) {
          int l = abufferedimage[0].getWidth();
          i1 = abufferedimage[0].getHeight();

          if(MathHelper.func_151236_b(l) != l || MathHelper.func_151236_b(i1) != i1) {
            throw new RuntimeException("Unable to load extra miplevels, source-texture is not power of two");
          }
        }

        for(Integer aList : list) {
          i1 = aList;

          if(i1 > 0 && i1 < abufferedimage.length - 1 && abufferedimage[i1] == null) {
            ResourceLocation resourcelocation2 = this.completeResourceLocation(resourceLocation, i1);

            try {
              abufferedimage[i1] = TextureUtil
                  .func_177053_a(resourceManager.func_110536_a(resourcelocation2).func_110527_b());
            } catch(IOException ioexception) {
              TinkerRegistry.log
                  .error("Unable to load miplevel {} from: {}", i1, resourcelocation2,
                         ioexception);
            }
          }
        }
      }

      AnimationMetadataSection animationmetadatasection = iresource.func_110526_a("animation");
      textureAtlasSprite.func_180598_a(abufferedimage, animationmetadatasection);

      return textureAtlasSprite;

    } catch(RuntimeException runtimeexception) {
      TinkerRegistry.log.error("Unable to parse metadata from " + resourcelocation1, runtimeexception);
    } catch(IOException ioexception1) {
      TinkerRegistry.log.error("Unable to load " + resourcelocation1, ioexception1);
    }

    return null;
  }

  protected ResourceLocation completeResourceLocation(ResourceLocation location, int p_147634_2_) {
    if(p_147634_2_ == 0) {
      return new ResourceLocation(location.func_110624_b(),
                                  String.format("%s/%s%s", "textures", location.func_110623_a(), ".png"));
    }

    return new ResourceLocation(location.func_110624_b(), String
        .format("%s/mipmaps/%s.%d%s", "textures", location.func_110623_a(), p_147634_2_, ".png"));
  }

  // borrowed from Shadows of Physis
  // Thanks TTFTCUTS! :)
  public static int getPerceptualBrightness(int col) {
    double r = RenderUtil.red(col) / 255.0;
    double g = RenderUtil.green(col) / 255.0;
    double b = RenderUtil.blue(col) / 255.0;

    return getPerceptualBrightness(r, g, b);
  }

  public static int getPerceptualBrightness(double r, double g, double b) {

    double brightness = Math.sqrt(0.241 * r * r + 0.691 * g * g + 0.068 * b * b);

    return (int) (brightness * 255);
  }

  protected static int mult(int c1, int c2) {
    return (int) ((float) c1 * (c2 / 255f));
  }

  // Get coordinates from index and vice versa
  protected int getX(int pxCoord) {
    return pxCoord % field_130223_c;
  }

  protected int getY(int pxCoord) {
   return pxCoord / field_130223_c;
  }

  protected int coord(int x, int y) {
    return y * field_130223_c + x;
  }
}
