package slimeknights.tconstruct.library.client.renderer;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSlime;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.awt.*;

import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.RenderUtil;

@SideOnly(Side.CLIENT)
public class RenderTinkerSlime extends RenderSlime {

  public static final Factory FACTORY_BlueSlime = new Factory(0xff67f0f5);

  public static final ResourceLocation slimeTextures = Util.getResource("textures/entity/slime.png");

  private final int color;
  private final ResourceLocation texture;

  public RenderTinkerSlime(RenderManager renderManager, int color) {
    this(renderManager, color, slimeTextures);
  }

  public RenderTinkerSlime(RenderManager renderManager, int color, ResourceLocation texture) {
    this(renderManager, color, color, new ModelSlime(16), 0.25f, texture);
  }

  public RenderTinkerSlime(RenderManager renderManagerIn, int color, int colorLayer, ModelBase modelBaseIn, float shadowSizeIn, ResourceLocation texture) {
    super(renderManagerIn, modelBaseIn, shadowSizeIn);
    this.color = color;
    this.texture = texture;

    // replace slime layer with our own colorable variant
    this.field_177097_h.clear();
    this.func_177094_a(new LayerSlimeGelColored(this, colorLayer));
  }

  @Override
  public void func_76986_a(EntitySlime entity, double x, double y, double z, float entityYaw, float partialTicks) {
    RenderUtil.setColorRGBA(color);
    super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
  }

  @Override
  protected ResourceLocation func_110775_a(EntitySlime entity) {
    return this.texture;
  }

  @Override
  protected int func_77030_a(EntitySlime entitylivingbaseIn, float lightBrightness, float partialTickTime) {
    return color;
  }

  public static class LayerSlimeGelColored implements LayerRenderer<EntitySlime> {
    private final RenderSlime slimeRenderer;
    private final ModelBase slimeModel;
    private final int color;

    private float ticking;

    public static boolean magicMushrooms = false;

    public LayerSlimeGelColored(RenderSlime slimeRendererIn, int color)
    {
      this.slimeRenderer = slimeRendererIn;
      this.color = color;
      slimeModel = new ModelSlime(0);
    }

    public void func_177141_a(EntitySlime entitylivingbaseIn, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale)
    {
      ticking += partialTicks;
      if (!entitylivingbaseIn.func_82150_aj())
      {
        if(magicMushrooms) {
          RenderUtil.setColorRGBA(Color.HSBtoRGB(ticking / 100f, 0.65f, 0.8f) | (color & (0xFF << 24)));
        }
        else {
          RenderUtil.setColorRGBA(color);
        }
        GlStateManager.func_179108_z();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b(770, 771);
        this.slimeModel.func_178686_a(this.slimeRenderer.func_177087_b());
        this.slimeModel.func_78088_a(entitylivingbaseIn, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
        GlStateManager.func_179084_k();
        GlStateManager.func_179133_A();
      }
    }

    public boolean func_177142_b()
    {
      return true;
    }
  }

  private static class Factory implements IRenderFactory<EntitySlime> {

    private final int color;

    public Factory(int color) {
      this.color = color;
    }

    @Override
    public Render<? super EntitySlime> createRenderFor(RenderManager manager) {
      return new RenderTinkerSlime(manager, color);
    }
  }
}
