package slimeknights.tconstruct.debug;

import com.google.common.collect.Lists;

import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.StatCollector;

import java.util.List;

import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;

public class LocalizationCheckCommand extends CommandBase {

  @Override
  public int func_82362_a() {
    return 0;
  }

  @Override
  public String func_71517_b() {
    return "checkLocalizationStrings";
  }

  @Override
  public String func_71518_a(ICommandSender sender) {
    return "/" + func_71517_b() + " [Material-Identifier]";
  }

  @Override
  public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
    if(args.length != 1) {
      return null;
    }

    List<String> completions = Lists.newLinkedList();
    String matName = args[0].toLowerCase();
    for(Material mat : TinkerRegistry.getAllMaterials()) {
      if(mat.identifier.toLowerCase().startsWith(matName)) {
        completions.add(mat.identifier);
      }
    }

    return completions;
  }

  @Override
  public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
    if(args.length > 1) {
      throw new WrongUsageException(func_71518_a(sender));
    }

    if(args.length > 0) {
      Material mat = TinkerRegistry.getMaterial(args[0]);
      if(mat == Material.UNKNOWN) {
        throw new CommandException("Unknown material: " + args[0]);
      }

      scanMaterial(mat, sender);
    }
    else {
      for(Material mat : TinkerRegistry.getAllMaterials()) {
        scanMaterial(mat, sender);
      }
    }
  }

  private void scanMaterial(Material material, ICommandSender sender) {
    checkStr(String.format(Material.LOC_Name, material.identifier), sender);
  }

  private void checkStr(String str, ICommandSender sender) {
    if(!StatCollector.func_94522_b(str)) {
      sender.func_145747_a(new ChatComponentText("Missing localization for name: " + str));
    }
  }
}
