package slimeknights.tconstruct.world.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.Random;

import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.block.BlockSlimeGrass.FoliageType;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class BlockSlimeVine extends BlockVine {
  protected final FoliageType foliage;
  protected final BlockSlimeVine nextStage;

  public BlockSlimeVine(FoliageType foliage, BlockSlimeVine nextStage) {
    this.func_149647_a(TinkerRegistry.tabWorld);
    this.func_149672_a(field_149779_h);

    this.foliage = foliage;
    this.nextStage = nextStage;
  }
/*
  @Override
  public void getSubBlocks(Item itemIn, CreativeTabs tab, List list) {
    if(this == TinkerWorld.slimeVinePurple1 || this == TinkerWorld.slimeVineBlue1) {
      list.add(new ItemStack(this, 1, 0));
    }
  }
*/
  private Boolean canAttachTo(IBlockAccess world, BlockPos pos) {
    Block block = world.func_180495_p(pos).func_177230_c();

    return block.func_149686_d() && block.func_149688_o().func_76230_c();
  }

  /**
   * Called by ItemBlocks just before a block is actually set in the world, to allow for adjustments to the
   * IBlockstate
   */
  public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer)
  {
    IBlockState iblockstate = this.func_176223_P();
    iblockstate = iblockstate.func_177226_a(field_176273_b, canAttachTo(worldIn, pos.func_177978_c()));
    iblockstate = iblockstate.func_177226_a(field_176278_M, canAttachTo(worldIn, pos.func_177974_f()));
    iblockstate = iblockstate.func_177226_a(field_176279_N, canAttachTo(worldIn, pos.func_177968_d()));
    iblockstate = iblockstate.func_177226_a(field_176280_O, canAttachTo(worldIn, pos.func_177976_e()));
    return iblockstate;
  }

  @Override
  public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
    if(worldIn.field_72995_K) {
      return;
    }

    // are we anchored to a block?
    if(!canAttachTo(worldIn, pos.func_177978_c()) && !canAttachTo(worldIn, pos.func_177974_f()) && !canAttachTo(worldIn, pos.func_177968_d()) && !canAttachTo(worldIn, pos.func_177976_e())) {
      // are we held up from above?
      if(!(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockVine)) {
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
      }
    }

    // notify bottom block to update its state since ours might have changed as well
    BlockPos down = pos.func_177977_b();
    while(worldIn.func_180495_p(down).func_177230_c() instanceof BlockVine) {
      worldIn.func_175689_h(down);
      down = down.func_177977_b();
    }
  }

  @Override
  public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    if(!worldIn.field_72995_K) {
      if (rand.nextInt(4) == 0) {
        grow(worldIn, rand, pos, state);
      }
    }
  }

  public void grow(World worldIn, Random rand, BlockPos pos, IBlockState state) {
    // end parts don't grow
    if(nextStage == null) {
      return;
    }

    // we only grow down
    BlockPos below = pos.func_177977_b();
    if(worldIn.func_175623_d(below)) {
      // free floating position?
      if(!canAttachTo(worldIn, below.func_177978_c()) && !canAttachTo(worldIn, below.func_177974_f()) && !canAttachTo(worldIn, below.func_177968_d()) && !canAttachTo(worldIn, below.func_177976_e())) {
        // at most 3 middle parts
        int i = 0;
        while(worldIn.func_180495_p(pos.func_177981_b(i)).func_177230_c() == this) {
          i++;
        }

        if(i > 2 || rand.nextInt(2) == 0) {
          state = nextStage.func_176223_P()
                           .func_177226_a(field_176273_b, state.func_177229_b(field_176273_b))
                           .func_177226_a(field_176278_M, state.func_177229_b(field_176278_M))
                           .func_177226_a(field_176279_N, state.func_177229_b(field_176279_N))
                           .func_177226_a(field_176280_O, state.func_177229_b(field_176280_O));
        }
      }

      worldIn.func_175656_a(below, state);
    }
  }

  @Override
  @SideOnly(Side.CLIENT)
  public int func_149635_D ()
  {
    return 0xffffff;
  }

  // Used for the item
  @SideOnly(Side.CLIENT)
  @Override
  public int func_180644_h(IBlockState state) {
    return SlimeColorizer.getColorStatic(foliage);
  }

  // Used for the block in world
  @SideOnly(Side.CLIENT)
  @Override
  public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
    IBlockState state = worldIn.func_180495_p(pos);
    if(state.func_177230_c() != this) return func_149635_D();

    return SlimeColorizer.getColorForPos(pos.func_177963_a(SlimeColorizer.loop/2, 0, SlimeColorizer.loop/2), foliage);
  }
}
