package slimeknights.tconstruct.tools.traits;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

import java.util.List;

import javax.vecmath.Vector3d;

import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.potion.TinkerPotion;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.AbstractTraitLeveled;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitMagnetic extends AbstractTraitLeveled {

  public static TinkerPotion Magnetic = new MagneticPotion();

  public TraitMagnetic(int levels) {
    super("magnetic", 0xdddddd, 3, levels);
  }

  @Override
  public void afterBlockBreak(ItemStack tool, World world, Block block, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
    ModifierNBT data = new ModifierNBT(TinkerUtil.getModifierTag(tool, name));
    Magnetic.apply(player, 30, data.level);
  }

  @Override
  public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
    ModifierNBT data = new ModifierNBT(TinkerUtil.getModifierTag(tool, name));
    Magnetic.apply(player, 30, data.level);
  }

  private static class MagneticPotion extends TinkerPotion {

    public MagneticPotion() {
      super(Util.getResource("magnetic"), false, false);
    }

    @Override
    public boolean func_76397_a(int duration, int strength) {
      return (duration & 1) == 0; // basically %2
    }

    @Override
    public void func_76394_a(EntityLivingBase entity, int id) {
      // super magnetic - inspired by botanias code
      double x = entity.field_70165_t;
      double y = entity.field_70163_u;
      double z = entity.field_70161_v;
      double range = 1.8d;
      range += entity.func_70660_b(this).func_76458_c() * 0.3f;

      List<EntityItem> items = entity.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_178781_a(x - range, y - range, z - range, x + range, y + range, z + range));
      int pulled = 0;
      for(EntityItem item : items) {
        if(item.func_92059_d() == null || item.func_92059_d().func_77973_b() == null || item.field_70128_L) {
          continue;
        }

        if(pulled > 200) {
          break;
        }

        // constant force!
        float strength = 0.07f;

        // calculate direction: item -> player
        Vector3d vec = new Vector3d(x, y, z);
        vec.sub(new Vector3d(item.field_70165_t, item.field_70163_u, item.field_70161_v));

        vec.normalize();
        vec.scale(strength);

        // we calculated the movement vector and set it to the correct strength.. now we apply it \o/
        item.field_70159_w += vec.x;
        item.field_70181_x += vec.y;
        item.field_70179_y += vec.z;

        pulled++;
      }
    }
  }
}
