package slimeknights.tconstruct.tools;

import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

import java.util.List;

import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.shared.block.BlockTable;

import static net.minecraftforge.oredict.RecipeSorter.Category.SHAPED;

public class TableRecipe extends ShapedOreRecipe {

  static {
    RecipeSorter.register("tconstruct:table", TableRecipe.class, SHAPED, "before:minecraft:shaped");
  }

  public final List<ItemStack> outputBlocks; // first one found of these determines the output block used

  public TableRecipe(List<ItemStack> variantItems, BlockTable result, int meta, Object... recipe) {
    super(new ItemStack(result, 1, meta), recipe);
    this.outputBlocks = variantItems;
  }

  @Override
  public ItemStack func_77572_b(InventoryCrafting craftMatrix) {
    for(int i = 0; i < craftMatrix.func_70302_i_(); i++) {
      for(ItemStack ore : outputBlocks) {
        ItemStack stack = craftMatrix.func_70301_a(i);
        if(OreDictionary.itemMatches(ore, stack, false) && Block.func_149634_a(stack.func_77973_b()) != null) {
          BlockTable block = (BlockTable) Block.func_149634_a(output.func_77973_b());
          return BlockTable.createItemstack(block, output.func_77952_i(), Block.func_149634_a(stack.func_77973_b()),
                                            stack.func_77952_i());
        }
      }
    }

    return super.func_77572_b(craftMatrix);
  }

  @Override
  public ItemStack func_77571_b() {
    if(!outputBlocks.isEmpty() && output != null) {
      ItemStack stack = outputBlocks.get(0);
      BlockTable block = (BlockTable) Block.func_149634_a(output.func_77973_b());
      int meta = stack.func_77952_i();
      if(meta == OreDictionary.WILDCARD_VALUE) {
        meta = 0;
      }
      return BlockTable.createItemstack(block, output.func_77952_i(), Block.func_149634_a(stack.func_77973_b()), meta);
    }
    return super.func_77571_b();
  }
}
