package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

import java.util.List;

import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeWrapper;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.tools.TableRecipe;

public class TableRecipeWrapper extends ShapedOreRecipeWrapper {

  private final List<ItemStack> outputs;

  public TableRecipeWrapper(TableRecipe recipe) {
    super(recipe);

    ImmutableList.Builder<ItemStack> builder = ImmutableList.builder();
    for(ItemStack stack : recipe.outputBlocks) {
      BlockTable block = (BlockTable) BlockTable.func_149634_a(recipe.func_77571_b().func_77973_b());
      Block legBlock = Block.func_149634_a(stack.func_77973_b());
      if(stack.func_77952_i() == OreDictionary.WILDCARD_VALUE) {
        for(ItemStack sub : JEIPlugin.jeiHelpers.getStackHelper().getSubtypes(stack)) {
            builder.add(BlockTable.createItemstack(block, recipe.func_77571_b().func_77952_i(), legBlock, sub.func_77952_i()));
        }
      }
      else {
        builder.add(BlockTable.createItemstack(block, recipe.func_77571_b().func_77952_i(), legBlock, stack.func_77952_i()));
      }
    }
    outputs = builder.build();
  }

  @Override
  public List getOutputs() {
    return outputs;
  }
}
