package slimeknights.tconstruct.library.utils;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

import java.util.List;

public final class EntityUtil {
  private EntityUtil() {}

  public static MovingObjectPosition raytraceEntityPlayerLook(EntityPlayer player, float range) {
    Vec3 eye = new Vec3(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v); // Entity.getPositionEyes
    Vec3 look = player.func_70676_i(1.0f);

    return raytraceEntity(player, eye, look, range, true);
  }

  // based on EntityRenderer.getMouseOver
  public static MovingObjectPosition raytraceEntity(Entity entity, Vec3 start, Vec3 look, double range, boolean ignoreCanBeCollidedWith) {
    //Vec3 look = entity.getLook(partialTicks);
    Vec3 direction = start.func_72441_c(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range);

    //Vec3 direction = vec3.addVector(vec31.xCoord * d0, vec31.yCoord * d0, vec31.zCoord * d0);
    Entity pointedEntity = null;
    Vec3 hit = null;
    AxisAlignedBB bb = entity.func_174813_aQ().func_72321_a(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range).func_72314_b(1,1,1);
    @SuppressWarnings("unchecked")
    List<Entity> entitiesInArea = entity.field_70170_p.func_72839_b(entity, bb);
    double range2 = range; // range to the current candidate. Used to find the closest entity.

    for(Entity candidate : entitiesInArea)
    {
      if (ignoreCanBeCollidedWith || candidate.func_70067_L())
      {
        // does our vector go through the entity?
        double colBorder = candidate.func_70111_Y();
        AxisAlignedBB entityBB = candidate.func_174813_aQ().func_72314_b(colBorder, colBorder, colBorder);
        MovingObjectPosition movingobjectposition = entityBB.func_72327_a(start, direction);

        // needs special casing: vector starts inside the entity
        if (entityBB.func_72318_a(start))
        {
          if (0.0D < range2 || range2 == 0.0D)
          {
            pointedEntity = candidate;
            hit = movingobjectposition == null ? start : movingobjectposition.field_72307_f;
            range2 = 0.0D;
          }
        }
        else if (movingobjectposition != null)
        {
          double dist = start.func_72438_d(movingobjectposition.field_72307_f);

          if (dist < range2 || range2 == 0.0D)
          {
            if (candidate == entity.field_70154_o && !entity.canRiderInteract())
            {
              if (range2 == 0.0D)
              {
                pointedEntity = candidate;
                hit = movingobjectposition.field_72307_f;
              }
            }
            else
            {
              pointedEntity = candidate;
              hit = movingobjectposition.field_72307_f;
              range2 = dist;
            }
          }
        }
      }
    }

    if (pointedEntity != null && range2 < range)
    {
      return new MovingObjectPosition(pointedEntity, hit);
    }
    return null;
  }
}
