package slimeknights.tconstruct.gadgets.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHangingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

import java.util.List;

import slimeknights.tconstruct.gadgets.entity.EntityFancyItemFrame;
import slimeknights.tconstruct.shared.TinkerCommons;

public class ItemFancyItemFrame extends ItemHangingEntity {

  public ItemFancyItemFrame() {
    super(EntityFancyItemFrame.class);

    this.func_77627_a(true);
  }

  @Override
  public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
    subItems.add(new ItemStack(itemIn, 1, EntityFancyItemFrame.FrameType.JEWEL.ordinal()));

    if(TinkerCommons.nuggetAlubrass != null) {
      subItems.add(new ItemStack(itemIn, 1, EntityFancyItemFrame.FrameType.ALUBRASS.ordinal()));
    }
    if(TinkerCommons.nuggetCobalt != null) {
      subItems.add(new ItemStack(itemIn, 1, EntityFancyItemFrame.FrameType.COBALT.ordinal()));
    }
    if(TinkerCommons.nuggetArdite != null) {
      subItems.add(new ItemStack(itemIn, 1, EntityFancyItemFrame.FrameType.ARDITE.ordinal()));
    }
    if(TinkerCommons.nuggetManyullyn != null) {
      subItems.add(new ItemStack(itemIn, 1, EntityFancyItemFrame.FrameType.MANYULLYN.ordinal()));
    }

    subItems.add(new ItemStack(itemIn, 1, EntityFancyItemFrame.FrameType.GOLD.ordinal()));
  }

  @Override
  public String func_77667_c(ItemStack stack) {
    String type = EntityFancyItemFrame.FrameType.fromMeta(stack.func_77960_j()).toString().toLowerCase();

    return super.func_77667_c(stack) + "." + type;
  }

  public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ)
  {
    if (side == EnumFacing.DOWN)
    {
      return false;
    }
    else if (side == EnumFacing.UP)
    {
      return false;
    }
    else
    {
      BlockPos blockpos = pos.func_177972_a(side);

      if (!playerIn.func_175151_a(blockpos, side, stack))
      {
        return false;
      }
      else
      {
        EntityHanging entityhanging = new EntityFancyItemFrame(worldIn, blockpos, side, stack.func_77960_j());

        if (entityhanging.func_70518_d())
        {
          if (!worldIn.field_72995_K)
          {
            worldIn.func_72838_d(entityhanging);
          }

          --stack.field_77994_a;
        }

        return true;
      }
    }
  }
}
