package slimeknights.tconstruct.tools.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;

import slimeknights.tconstruct.tools.events.TinkerToolEvent;

public class SlotToolStationOut extends Slot {

  public ContainerToolStation parent;

  public SlotToolStationOut(int index, int xPosition, int yPosition, ContainerToolStation container) {
    super(new InventoryCraftResult(), index, xPosition, yPosition);

    this.parent = container;
  }

  @Override
  public boolean func_75214_a(ItemStack stack) {
    return false;
  }

  @Override
  public void func_82870_a(EntityPlayer playerIn, ItemStack stack) {
    FMLCommonHandler.instance().firePlayerCraftingEvent(playerIn, stack, parent.getTile());
    parent.onResultTaken(playerIn, stack);
    stack.func_77980_a(playerIn.func_130014_f_(), playerIn, 1);

    super.func_82870_a(playerIn, stack);
  }
}
