package slimeknights.tconstruct.shared.block;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;

import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.world.TinkerWorld;

public class BlockSoil extends EnumBlock<BlockSoil.SoilTypes> {

  public static final PropertyEnum<SoilTypes> TYPE = PropertyEnum.func_177709_a("type", SoilTypes.class);

  public BlockSoil() {
    super(Material.field_151595_p, TYPE, SoilTypes.class);
    this.field_149765_K = 0.8F;
    this.func_149711_c(3.0f);

    this.func_149672_a(field_149776_m);

    setHarvestLevel("Shovel", -1);
    func_149647_a(TinkerRegistry.tabGeneral);
  }

  @SideOnly(Side.CLIENT)
  @Override
  public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    for(SoilTypes type : SoilTypes.values()) {
      if(isTypeEnabled(type)) {
        list.add(new ItemStack(this, 1, type.getMeta()));
      }
    }
  }

  protected boolean isTypeEnabled(SoilTypes type) {
    switch(type) {
      case GROUT:
        return TConstruct.pulseManager.isPulseLoaded(TinkerSmeltery.PulseId);
      case SLIMY_MUD_BLUE:
        return TinkerCommons.matSlimeBallBlue != null;
      case SLIMY_MUD_MAGMA:
        return TinkerCommons.matSlimeBallMagma != null;
      case MUDBRICK:
        return TinkerCommons.mudBrick != null;
      case SLIMY_MUD_GREEN:
      case GRAVEYARD:
      case CONSECRATED:
        return true;
    }

    return false;
  }

  @Override
  public void func_176199_a(World worldIn, BlockPos pos,Entity entityIn) {
    IBlockState state = worldIn.func_180495_p(pos);
    switch(state.func_177229_b(TYPE)) {
      case SLIMY_MUD_GREEN:
      case SLIMY_MUD_BLUE:
        processSlimyMud(entityIn);
        break;
      case GRAVEYARD:
        processGraveyardSoil(entityIn);
        break;
      case CONSECRATED:
        processConsecratedSoil(entityIn);
        break;
    }
  }

  // slow down
  protected void processSlimyMud(Entity entity) {
    entity.field_70159_w *= 0.4;
    entity.field_70179_y *= 0.4;
    if (entity instanceof EntityLivingBase)
    {
      ((EntityLivingBase) entity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 1));
    }
  }

  // damage and set undead entities on fire
  protected void processConsecratedSoil(Entity entity) {
    if(entity instanceof EntityLiving) {
      EntityLivingBase entityLiving = (EntityLivingBase) entity;
      if(entityLiving.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
        entityLiving.func_70097_a(DamageSource.field_76376_m, 1);
        entityLiving.func_70015_d(1);
      }
    }
  }

  // heal undead entities
  protected void processGraveyardSoil(Entity entity) {
    if(entity instanceof EntityLiving) {
      EntityLivingBase entityLiving = (EntityLivingBase) entity;
      if(entityLiving.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
        entityLiving.func_70691_i(1);
      }
    }
  }

  @Override
  public boolean canSustainPlant(IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
    SoilTypes type = world.func_180495_p(pos).func_177229_b(TYPE);
    if(type == SoilTypes.SLIMY_MUD_GREEN || type == SoilTypes.SLIMY_MUD_BLUE) {
      // can sustain slimeplants
      return plantable.getPlantType(world, pos) == TinkerWorld.slimePlantType;
    }
    return super.canSustainPlant(world, pos, direction, plantable);
  }

  public enum SoilTypes implements IStringSerializable, EnumBlock.IEnumMeta {
    GROUT,
    SLIMY_MUD_GREEN,
    SLIMY_MUD_BLUE,
    GRAVEYARD,
    CONSECRATED,
    SLIMY_MUD_MAGMA,
    MUDBRICK;

    public  final int meta;

    SoilTypes() {
      meta = ordinal();
    }

    @Override
    public String func_176610_l() {
      return this.toString();
    }

    @Override
    public int getMeta() {
      return meta;
    }
  }
}
