package slimeknights.tconstruct.tools.traits;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitFlammable extends AbstractTrait {

  public TraitFlammable() {
    super("flammable", 0xffffff);
  }

  @Override
  public void onBlock(ItemStack tool, EntityPlayer player, LivingHurtEvent event) {
    // set attacker on fire
    if(event.source.func_76346_g() != null) {
      event.source.func_76346_g().func_70015_d(3);
    }

    // block fire damage
    if(event.source.func_76347_k()) {
      event.setCanceled(true);
      ToolHelper.damageTool(tool, 3, player);
    }
  }
}
