package slimeknights.tconstruct.library.tinkering;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IndestructibleEntityItem extends EntityItem {

  public IndestructibleEntityItem(World worldIn, double x, double y, double z) {
    super(worldIn, x, y, z);
    field_70178_ae = true;
  }

  public IndestructibleEntityItem(World worldIn, double x, double y, double z, ItemStack stack) {
    super(worldIn, x, y, z, stack);
    field_70178_ae = true;
  }

  public IndestructibleEntityItem(World worldIn) {
    super(worldIn);
    field_70178_ae = true;
  }

  @Override
  public boolean func_70097_a(DamageSource source, float amount) {
    if(source.func_76355_l().equals(DamageSource.field_76380_i.field_76373_n)) {
      return true;
    }
    // prevent any damage besides out of world
    return false;
  }

  public static class EventHandler {
    public static final EventHandler instance = new EventHandler();
    private EventHandler() {}

    @SubscribeEvent
    public void onExpire(ItemExpireEvent event) {
      if(event.entityItem instanceof IndestructibleEntityItem) {
        event.setCanceled(true);
      }
    }
  }
}
