/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlime;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.worldgen.SlimeTreeGenerator;

public class BlockSlimeSapling
extends BlockSapling {
    public static PropertyEnum<BlockSlimeGrass.FoliageType> FOLIAGE = BlockSlimeGrass.FOLIAGE;

    public BlockSlimeSapling() {
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabWorld);
        this.setDefaultState(this.blockState.getBaseState());
        this.setStepSound(soundTypeGrass);
    }

    public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (BlockSlimeGrass.FoliageType type : BlockSlimeGrass.FoliageType.values()) {
            list.add(new ItemStack((Block)this, 1, this.getMetaFromState(this.getDefaultState().withProperty(FOLIAGE, (Comparable)((Object)type)))));
        }
    }

    protected BlockState createBlockState() {
        return new BlockState((Block)this, new IProperty[]{FOLIAGE, STAGE, TYPE});
    }

    public IBlockState getStateFromMeta(int meta) {
        if (meta < 0 || meta >= BlockSlimeGrass.FoliageType.values().length) {
            meta = 0;
        }
        BlockSlimeGrass.FoliageType grass = BlockSlimeGrass.FoliageType.values()[meta];
        return this.getDefaultState().withProperty(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)grass));
    }

    public int getMetaFromState(IBlockState state) {
        return ((BlockSlimeGrass.FoliageType)((Object)state.getValue(BlockSlimeGrass.FOLIAGE))).ordinal();
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(IBlockState state) {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        return 0xFFFFFF;
    }

    public boolean isReplaceable(World worldIn, BlockPos pos) {
        return false;
    }

    protected boolean canPlaceBlockOn(Block ground) {
        return ground == TinkerWorld.slimeGrass || ground == TinkerWorld.slimeDirt;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return TinkerWorld.slimePlantType;
    }

    public int getDamageValue(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.getBlockState(pos);
        return iblockstate.getBlock().getMetaFromState(iblockstate);
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        BlockSlime.SlimeType slimeType = BlockSlime.SlimeType.GREEN;
        if (state.getValue(FOLIAGE) == BlockSlimeGrass.FoliageType.ORANGE) {
            slimeType = BlockSlime.SlimeType.MAGMA;
        }
        IBlockState slimeGreen = TinkerWorld.slimeBlockCongealed.getDefaultState().withProperty(BlockSlime.TYPE, (Comparable)((Object)slimeType));
        IBlockState leaves = TinkerWorld.slimeLeaves.getDefaultState().withProperty(BlockSlimeGrass.FOLIAGE, state.getValue(FOLIAGE));
        SlimeTreeGenerator gen = new SlimeTreeGenerator(5, 4, slimeGreen, leaves, null);
        worldIn.setBlockToAir(pos);
        gen.generateTree(rand, worldIn, pos);
        if (worldIn.isAirBlock(pos)) {
            worldIn.setBlockState(pos, state, 4);
        }
    }
}

