/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.traits.AbstractTrait;

public class TraitSlimey
extends AbstractTrait {
    private static float chance = 0.0033f;
    protected final Class<? extends EntitySlime> slime;

    public TraitSlimey(String suffix, Class<? extends EntitySlime> slime) {
        super("slimey_" + suffix, EnumChatFormatting.GREEN);
        this.slime = slime;
    }

    @Override
    public String getLocalizedName() {
        return Util.translate(String.format("modifier.%s.name", "slimey"), new Object[0]);
    }

    @Override
    public String getLocalizedDesc() {
        return Util.translate(String.format("modifier.%s.desc", "slimey"), new Object[0]);
    }

    @Override
    public void afterBlockBreak(ItemStack tool, World world, Block block, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        if (wasEffective && !world.isRemote && random.nextFloat() < chance) {
            this.spawnSlime(player, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, world);
        }
    }

    @Override
    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (!target.isEntityAlive() && !target.worldObj.isRemote && random.nextFloat() < chance) {
            this.spawnSlime(player, target.posX, target.posY, target.posZ, target.worldObj);
        }
    }

    protected void spawnSlime(EntityLivingBase player, double x, double y, double z, World world) {
        try {
            EntitySlime entity = this.slime.getConstructor(World.class).newInstance(world);
            entity.setSlimeSize(1);
            entity.setPosition(x, y, z);
            world.spawnEntityInWorld((Entity)entity);
            entity.setLastAttacker((Entity)player);
            entity.playLivingSound();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

