/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.tools.client.GuiStencilTable;
import slimeknights.tconstruct.tools.inventory.ContainerStencilTable;

public class StencilTableSelectionPacket
extends AbstractPacketThreadsafe {
    public ItemStack output;

    public StencilTableSelectionPacket() {
    }

    public StencilTableSelectionPacket(ItemStack output) {
        this.output = output;
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        Container container = Minecraft.getMinecraft().thePlayer.openContainer;
        if (container instanceof ContainerStencilTable) {
            ((ContainerStencilTable)container).setOutput(this.output);
            if (Minecraft.getMinecraft().currentScreen instanceof GuiStencilTable) {
                ((GuiStencilTable)Minecraft.getMinecraft().currentScreen).onSelectionPacket(this);
            }
        }
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        Container container = netHandler.playerEntity.openContainer;
        if (container instanceof ContainerStencilTable) {
            ((ContainerStencilTable)container).setOutput(this.output);
            WorldServer server = netHandler.playerEntity.getServerForPlayer();
            for (EntityPlayer player : server.playerEntities) {
                if (player == netHandler.playerEntity || !(player.openContainer instanceof ContainerStencilTable) || !((BaseContainer)container).sameGui((BaseContainer)player.openContainer)) continue;
                ((ContainerStencilTable)player.openContainer).setOutput(this.output);
                TinkerNetwork.sendTo((AbstractPacket)this, (EntityPlayerMP)player);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.output = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.output);
    }
}

