/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client.module;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.tools.client.GuiButtonItem;
import slimeknights.tconstruct.tools.client.GuiPartBuilder;
import slimeknights.tconstruct.tools.client.GuiTinkerStation;
import slimeknights.tconstruct.tools.client.module.GuiSideButtons;
import slimeknights.tconstruct.tools.network.PartCrafterSelectionPacket;

public class GuiButtonsPartCrafter
extends GuiSideButtons {
    private final IInventory patternChest;

    public GuiButtonsPartCrafter(GuiPartBuilder parent, Container container, IInventory patternChest) {
        super(parent, container, 4, false);
        this.patternChest = patternChest;
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        int index = 0;
        ArrayList patterns = Lists.newArrayList(TinkerRegistry.getStencilTableCrafting());
        ListIterator iter = patterns.listIterator();
        while (iter.hasNext()) {
            ItemStack pattern = (ItemStack)iter.next();
            boolean found = false;
            for (int i = 0; i < this.patternChest.getSizeInventory(); ++i) {
                if (!ItemStack.areItemStacksEqual((ItemStack)pattern, (ItemStack)this.patternChest.getStackInSlot(i))) continue;
                found = true;
                break;
            }
            if (!found) {
                found = ItemStack.areItemStacksEqual((ItemStack)pattern, (ItemStack)this.parent.inventorySlots.getSlot(2).getStack());
            }
            if (found) continue;
            iter.remove();
        }
        this.buttonList.clear();
        for (ItemStack stencil : patterns) {
            Item part = Pattern.getPartFromTag(stencil);
            if (part == null || !(part instanceof MaterialItem)) continue;
            ItemStack icon = ((MaterialItem)part).getItemstackWithMaterial(CustomTextureCreator.guiMaterial);
            GuiButtonItem<ItemStack> button = new GuiButtonItem<ItemStack>(index++, -1, -1, icon, stencil);
            this.shiftButton(button, 0, 18);
            this.addButton(button);
        }
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
    }

    protected void actionPerformed(GuiButton button) throws IOException {
        ItemStack pattern = (ItemStack)((GuiButtonItem)button).data;
        TinkerNetwork.sendToServer((AbstractPacket)new PartCrafterSelectionPacket(pattern));
    }

    protected void shiftButton(GuiButtonItem<ItemStack> button, int xd, int yd) {
        button.setGraphics(GuiTinkerStation.ICON_Button.shift(xd, yd), GuiTinkerStation.ICON_ButtonHover.shift(xd, yd), GuiTinkerStation.ICON_ButtonPressed.shift(xd, yd), GuiTinkerStation.ICONS);
    }
}

