/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.tools.IAoeTool;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.ToolHelper;

@SideOnly(value=Side.CLIENT)
public class RenderEvents
implements IResourceManagerReloadListener {
    private static final ResourceLocation widgetsTexPath = new ResourceLocation("textures/gui/widgets.png");
    private final TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];

    @SubscribeEvent
    public void onRenderGUI(RenderGameOverlayEvent.Pre event) {
        int slot;
        if (event.type != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        EntityPlayerSP player = Minecraft.getMinecraft().thePlayer;
        ItemStack stack = player.getCurrentEquippedItem();
        if (stack == null) {
            return;
        }
        if (stack.getItem() instanceof ToolCore && ((ToolCore)stack.getItem()).canUseSecondaryItem() && (slot = ToolHelper.getSecondaryItemSlot((EntityPlayer)player)) != player.inventory.currentItem) {
            int x = event.resolution.getScaledWidth() / 2 - 90 + slot * 20 + 2;
            int y = event.resolution.getScaledHeight() - 16 - 3;
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            Minecraft.getMinecraft().getTextureManager().bindTexture(widgetsTexPath);
            Gui.drawScaledCustomSizeModalRect((int)x, (int)y, (float)1.0f, (float)23.0f, (int)22, (int)22, (int)16, (int)16, (float)256.0f, (float)256.0f);
        }
    }

    @SubscribeEvent
    public void renderExtraBlockBreak(RenderWorldLastEvent event) {
        MovingObjectPosition mop;
        PlayerControllerMP controllerMP = Minecraft.getMinecraft().playerController;
        EntityPlayerSP player = Minecraft.getMinecraft().thePlayer;
        World world = player.worldObj;
        if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof IAoeTool && (mop = player.rayTrace((double)controllerMP.getBlockReachDistance(), event.partialTicks)) != null) {
            ItemStack stack = player.getCurrentEquippedItem();
            ImmutableList<BlockPos> extraBlocks = ((IAoeTool)stack.getItem()).getAOEBlocks(stack, world, (EntityPlayer)player, mop.getBlockPos());
            for (BlockPos pos : extraBlocks) {
                event.context.drawSelectionBox((EntityPlayer)player, new MovingObjectPosition(new Vec3(0.0, 0.0, 0.0), null, pos), 0, event.partialTicks);
            }
        }
        if (controllerMP.isHittingBlock && controllerMP.currentItemHittingBlock != null && controllerMP.currentItemHittingBlock.getItem() instanceof IAoeTool && ((IAoeTool)controllerMP.currentItemHittingBlock.getItem()).isAoeHarvestTool()) {
            ItemStack stack = controllerMP.currentItemHittingBlock;
            BlockPos pos = controllerMP.currentBlock;
            this.drawBlockDamageTexture(Tessellator.getInstance(), Tessellator.getInstance().getWorldRenderer(), (Entity)player, event.partialTicks, world, (List<BlockPos>)((IAoeTool)stack.getItem()).getAOEBlocks(stack, world, (EntityPlayer)player, pos));
        }
    }

    public void drawBlockDamageTexture(Tessellator tessellatorIn, WorldRenderer worldRendererIn, Entity entityIn, float partialTicks, World world, List<BlockPos> blocks) {
        double d0 = entityIn.lastTickPosX + (entityIn.posX - entityIn.lastTickPosX) * (double)partialTicks;
        double d1 = entityIn.lastTickPosY + (entityIn.posY - entityIn.lastTickPosY) * (double)partialTicks;
        double d2 = entityIn.lastTickPosZ + (entityIn.posZ - entityIn.lastTickPosZ) * (double)partialTicks;
        TextureManager renderEngine = Minecraft.getMinecraft().renderEngine;
        int progress = (int)(Minecraft.getMinecraft().playerController.curBlockDamageMP * 10.0f) - 1;
        if (progress < 0) {
            return;
        }
        renderEngine.bindTexture(TextureMap.locationBlocksTexture);
        GlStateManager.tryBlendFuncSeparate((int)774, (int)768, (int)1, (int)0);
        GlStateManager.enableBlend();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.doPolygonOffset((float)-3.0f, (float)-3.0f);
        GlStateManager.enablePolygonOffset();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableAlpha();
        GlStateManager.pushMatrix();
        worldRendererIn.begin(7, DefaultVertexFormats.BLOCK);
        worldRendererIn.setTranslation(-d0, -d1, -d2);
        worldRendererIn.markDirty();
        for (BlockPos blockpos : blocks) {
            IBlockState iblockstate;
            boolean hasBreak;
            double d3 = (double)blockpos.getX() - d0;
            double d4 = (double)blockpos.getY() - d1;
            double d5 = (double)blockpos.getZ() - d2;
            Block block = world.getBlockState(blockpos).getBlock();
            TileEntity te = world.getTileEntity(blockpos);
            boolean bl = hasBreak = block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull;
            if (!hasBreak) {
                boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
            }
            if (hasBreak || (iblockstate = world.getBlockState(blockpos)).getBlock().getMaterial() == Material.air) continue;
            TextureAtlasSprite textureatlassprite = this.destroyBlockIcons[progress];
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
            blockrendererdispatcher.renderBlockDamage(iblockstate, blockpos, textureatlassprite, (IBlockAccess)world);
        }
        tessellatorIn.draw();
        worldRendererIn.setTranslation(0.0, 0.0, 0.0);
        GlStateManager.disableAlpha();
        GlStateManager.doPolygonOffset((float)0.0f, (float)0.0f);
        GlStateManager.disablePolygonOffset();
        GlStateManager.enableAlpha();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.popMatrix();
    }

    public void onResourceManagerReload(IResourceManager resourceManager) {
        TextureMap texturemap = Minecraft.getMinecraft().getTextureMapBlocks();
        for (int i = 0; i < this.destroyBlockIcons.length; ++i) {
            this.destroyBlockIcons[i] = texturemap.getAtlasSprite("minecraft:blocks/destroy_stage_" + i);
        }
    }
}

