/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.multiblock;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;

public abstract class MultiblockCuboid
extends MultiblockDetection {
    public final boolean hasCeiling;
    public final boolean hasFloor;
    public final boolean hasFrame;

    public MultiblockCuboid(boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        this.hasCeiling = hasCeiling;
        this.hasFloor = hasFloor;
        this.hasFrame = hasFrame;
    }

    @Override
    public MultiblockDetection.MultiblockStructure detectMultiblock(World world, BlockPos center, int limit) {
        int height;
        ArrayList subBlocks = Lists.newArrayList();
        int masterY = center.getY();
        center = this.getOuterPos(world, center, EnumFacing.DOWN, limit + 1).up();
        int[] edges = new int[4];
        for (EnumFacing direction : EnumFacing.HORIZONTALS) {
            BlockPos pos = this.getOuterPos(world, center, direction, limit);
            edges[direction.getHorizontalIndex()] = pos.getX() - center.getX() + (pos.getZ() - center.getZ());
        }
        int xd = edges[EnumFacing.SOUTH.getHorizontalIndex()] - edges[EnumFacing.NORTH.getHorizontalIndex()] - 1;
        int zd = edges[EnumFacing.EAST.getHorizontalIndex()] - edges[EnumFacing.WEST.getHorizontalIndex()] - 1;
        if (xd > limit || zd > limit) {
            return null;
        }
        if (this.hasFloor && !this.detectFloor(world, center.down(), edges, subBlocks)) {
            return null;
        }
        for (height = 0; height <= limit && this.detectLayer(world, center.up(height), height, edges, subBlocks); ++height) {
        }
        if (height < 1 + masterY - center.getY()) {
            return null;
        }
        if (this.hasCeiling && !this.detectCeiling(world, center.up(height + 1), edges, subBlocks)) {
            return null;
        }
        return new MultiblockDetection.MultiblockStructure(xd, height, zd, subBlocks);
    }

    public boolean isFloorBlock(World world, BlockPos pos) {
        return this.isValidBlock(world, pos);
    }

    public boolean isCeilingBlock(World world, BlockPos pos) {
        return this.isValidBlock(world, pos);
    }

    public boolean isFrameBlock(World world, BlockPos pos) {
        return this.isValidBlock(world, pos);
    }

    public boolean isWallBlock(World world, BlockPos pos) {
        return this.isValidBlock(world, pos);
    }

    protected boolean detectFloor(World world, BlockPos center, int[] edges, List<BlockPos> subBlocks) {
        return this.detectPlaneXZ(world, center, edges, false, subBlocks);
    }

    private boolean detectCeiling(World world, BlockPos center, int[] edges, List<BlockPos> subBlocks) {
        return this.detectPlaneXZ(world, center, edges, true, subBlocks);
    }

    protected boolean detectPlaneXZ(World world, BlockPos center, int[] edges, boolean ceiling, List<BlockPos> subBlocks) {
        BlockPos from = center.add(edges[1], 0, edges[2]);
        BlockPos to = center.add(edges[3], 0, edges[0]);
        LinkedList candidates = Lists.newLinkedList();
        if (this.hasFrame) {
            LinkedList frame = Lists.newLinkedList();
            for (int x = 0; x <= to.getX() - from.getX(); ++x) {
                frame.add(from.add(x, 0, 0));
                frame.add(to.add(-x, 0, 0));
            }
            for (int z = 1; z < to.getZ() - from.getZ(); ++z) {
                frame.add(from.add(0, 0, z));
                frame.add(to.add(0, 0, -z));
            }
            for (BlockPos pos : frame) {
                if (!this.isFrameBlock(world, pos)) {
                    return false;
                }
                candidates.add(pos);
            }
        }
        from = from.add(1, 0, 1);
        to = to.add(-1, 0, -1);
        BlockPos z = from;
        while (z.getZ() <= to.getZ()) {
            BlockPos x = z;
            while (x.getX() <= to.getX()) {
                if (ceiling && !this.isCeilingBlock(world, x)) {
                    return false;
                }
                if (!ceiling && !this.isFloorBlock(world, x)) {
                    return false;
                }
                candidates.add(x);
                x = x.add(1, 0, 0);
            }
            z = z.add(0, 0, 1);
        }
        subBlocks.addAll(candidates);
        return true;
    }

    protected boolean detectLayer(World world, BlockPos center, int layer, int[] edges, List<BlockPos> subBlocks) {
        BlockPos from = center.add(edges[1], 0, edges[2]);
        BlockPos to = center.add(edges[3], 0, edges[0]);
        LinkedList candidates = Lists.newLinkedList();
        if (this.hasFrame) {
            LinkedList frame = Lists.newLinkedList();
            frame.add(from);
            frame.add(to);
            frame.add(new BlockPos(to.getX(), from.getY(), from.getZ()));
            frame.add(new BlockPos(from.getX(), from.getY(), to.getZ()));
            for (BlockPos pos : frame) {
                if (!this.isFrameBlock(world, pos)) {
                    return false;
                }
                candidates.add(pos);
            }
        }
        LinkedList blocks = Lists.newLinkedList();
        for (int x = edges[1] + 1; x < edges[3]; ++x) {
            for (int z = edges[2] + 1; z < edges[0]; ++z) {
                candidates.add(center.add(x, 0, z));
            }
        }
        for (BlockPos pos : blocks) {
            if (!this.isInnerBlock(world, pos)) {
                return false;
            }
            if (world.isAirBlock(pos)) continue;
            candidates.add(pos);
        }
        blocks = Lists.newLinkedList();
        for (int x = edges[1] + 1; x < edges[3]; ++x) {
            blocks.add(center.add(x, 0, edges[2]));
            blocks.add(center.add(x, 0, edges[0]));
        }
        for (int z = edges[2] + 1; z < edges[0]; ++z) {
            blocks.add(center.add(edges[1], 0, z));
            blocks.add(center.add(edges[3], 0, z));
        }
        for (BlockPos pos : blocks) {
            if (!this.isWallBlock(world, pos)) {
                return false;
            }
            candidates.add(pos);
        }
        subBlocks.addAll(candidates);
        return true;
    }
}

