/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.inventory;

import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.network.InventoryCraftingSyncPacket;

public class InventoryCraftingPersistent
extends InventoryCrafting {
    private final int length;
    private final Container eventHandler;
    private final IInventory parent;

    public InventoryCraftingPersistent(Container eventHandler, IInventory parent, int width, int height) {
        super(eventHandler, width, height);
        int k = width * height;
        assert (k == parent.getSizeInventory());
        this.parent = parent;
        this.length = k;
        this.eventHandler = eventHandler;
    }

    public int getSizeInventory() {
        return this.length;
    }

    public ItemStack getStackInSlot(int index) {
        return index >= this.getSizeInventory() ? null : this.parent.getStackInSlot(index);
    }

    public String getCommandSenderName() {
        return "container.crafting";
    }

    public boolean hasCustomName() {
        return false;
    }

    public ItemStack getStackInSlotOnClosing(int index) {
        return null;
    }

    public ItemStack decrStackSize(int index, int count) {
        if (this.getStackInSlot(index) != null) {
            if (this.getStackInSlot((int)index).stackSize <= count) {
                ItemStack itemstack = this.getStackInSlot(index);
                this.setInventorySlotContents(index, null);
                this.eventHandler.onCraftMatrixChanged((IInventory)this);
                return itemstack;
            }
            ItemStack itemstack = this.getStackInSlot(index).splitStack(count);
            if (this.getStackInSlot((int)index).stackSize == 0) {
                this.setInventorySlotContents(index, null);
            }
            this.eventHandler.onCraftMatrixChanged((IInventory)this);
            return itemstack;
        }
        return null;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        this.parent.setInventorySlotContents(index, stack);
        this.eventHandler.onCraftMatrixChanged((IInventory)this);
    }

    public void markDirty() {
        this.parent.markDirty();
        this.eventHandler.onCraftMatrixChanged((IInventory)this);
        TinkerTools.proxy.sendPacketToServerOnly((AbstractPacket)new InventoryCraftingSyncPacket());
    }

    public void clear() {
    }
}

