/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModifierTrait
extends AbstractTrait {
    protected final int maxLevel;

    public ModifierTrait(String identifier, int color) {
        this(identifier, color, 0, 0);
    }

    public ModifierTrait(String identifier, int color, int maxLevel, int countPerLevel) {
        super(identifier, color);
        TinkerRegistry.addTrait(this);
        this.maxLevel = maxLevel;
        this.aspects.clear();
        if (maxLevel > 0 && countPerLevel > 0) {
            this.addAspects(new ModifierAspect.MultiAspect(this, color, maxLevel, countPerLevel, 1));
        } else {
            if (maxLevel > 0) {
                this.addAspects(new ModifierAspect.LevelAspect(this, maxLevel));
            }
            this.addAspects(new ModifierAspect.DataAspect((IModifier)this, color), ModifierAspect.freeModifier);
        }
    }

    @Override
    public boolean canApplyCustom(ItemStack stack) {
        if (super.canApplyCustom(stack)) {
            return true;
        }
        if (this.maxLevel == 0) {
            return false;
        }
        NBTTagCompound tag = TinkerUtil.getModifierTag(stack, this.identifier);
        return ModifierNBT.readTag((NBTTagCompound)tag).level <= this.maxLevel;
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        if (this.maxLevel > 0) {
            return this.getLeveledTooltip(modifierTag, detailed);
        }
        return super.getTooltip(modifierTag, detailed);
    }
}

