/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import java.util.IdentityHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SlimeBounceHandler {
    private static final IdentityHashMap<Entity, SlimeBounceHandler> bouncingEntities = new IdentityHashMap();
    public final EntityLivingBase entityLiving;
    private int timer;
    private boolean wasInAir;
    private double bounce;
    private int bounceTick;
    private double lastMovX;
    private double lastMovZ;

    public SlimeBounceHandler(EntityLivingBase entityLiving, double bounce) {
        this.entityLiving = entityLiving;
        this.timer = 0;
        this.wasInAir = false;
        this.bounce = bounce;
        this.bounceTick = bounce != 0.0 ? entityLiving.ticksExisted : 0;
        bouncingEntities.put((Entity)entityLiving, this);
    }

    @SubscribeEvent
    public void playerTickPost(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player == this.entityLiving) {
            if (event.player.ticksExisted == this.bounceTick) {
                event.player.motionY = this.bounce;
                this.bounceTick = 0;
            }
            if (!(this.entityLiving.onGround || this.entityLiving.ticksExisted == this.bounceTick || this.lastMovX == this.entityLiving.motionX && this.lastMovZ == this.entityLiving.motionZ)) {
                double f = 0.935;
                this.entityLiving.motionX /= f;
                this.entityLiving.motionZ /= f;
                this.entityLiving.isAirBorne = true;
                this.lastMovX = this.entityLiving.motionX;
                this.lastMovZ = this.entityLiving.motionZ;
            }
            if (this.wasInAir && this.entityLiving.onGround) {
                if (this.timer == 0) {
                    this.timer = this.entityLiving.ticksExisted;
                } else if (this.entityLiving.ticksExisted - this.timer > 5) {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                    bouncingEntities.remove(this.entityLiving);
                }
            } else {
                this.timer = 0;
                this.wasInAir = true;
            }
        }
    }

    public static void addBounceHandler(EntityLivingBase entity) {
        SlimeBounceHandler.addBounceHandler(entity, 0.0);
    }

    public static void addBounceHandler(EntityLivingBase entity, double bounce) {
        if (!(entity instanceof EntityPlayer) || entity instanceof FakePlayer) {
            return;
        }
        SlimeBounceHandler handler = bouncingEntities.get(entity);
        if (handler == null) {
            MinecraftForge.EVENT_BUS.register((Object)new SlimeBounceHandler(entity, bounce));
        } else if (bounce != 0.0) {
            handler.bounce = bounce;
            handler.bounceTick = entity.ticksExisted;
        }
    }
}

