/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.SlimeBounceHandler;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;

public class ItemSlimeBoots
extends ItemArmor {
    public static ItemArmor.ArmorMaterial SLIME_MATERIAL = EnumHelper.addArmorMaterial((String)"SLIME", (String)Util.resource("slime"), (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0);

    public ItemSlimeBoots() {
        super(SLIME_MATERIAL, 0, 3);
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabGadgets);
        this.setMaxStackSize(1);
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == 3;
    }

    public ItemStack onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        int slot = 1;
        ItemStack itemstack = playerIn.getEquipmentInSlot(slot);
        if (itemstack == null) {
            playerIn.setCurrentItemOrArmor(slot, itemStackIn.copy());
            --itemStackIn.stackSize;
        }
        return itemStackIn;
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity == null) {
            return;
        }
        ItemStack feet = entity.getEquipmentInSlot(1);
        if (feet == null || feet.getItem() != this) {
            return;
        }
        if (!entity.isSneaking() && event.distance > 2.0f) {
            event.damageMultiplier = 0.0f;
            if (entity.worldObj.isRemote) {
                entity.motionY *= -0.9;
                event.entityLiving.isAirBorne = true;
                event.entityLiving.onGround = false;
                double f = 0.9500000000000001;
                entity.motionX /= f;
                entity.motionZ /= f;
            } else {
                event.setCanceled(true);
            }
            entity.playSound("mob.slime.small", 1.0f, 1.0f);
            SlimeBounceHandler.addBounceHandler(entity, entity.motionY);
        } else if (!entity.worldObj.isRemote && entity.isSneaking()) {
            event.damageMultiplier = 0.1f;
        }
    }
}

