/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.TinkerRegistry;

public class BlockPunji
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.create((String)"facing");
    public static final PropertyBool NORTH = PropertyBool.create((String)"north");
    public static final PropertyBool EAST = PropertyBool.create((String)"east");
    public static final PropertyBool NORTHEAST = PropertyBool.create((String)"northeast");
    public static final PropertyBool NORTHWEST = PropertyBool.create((String)"northwest");

    public BlockPunji() {
        super(Material.plants);
        this.setBlockBounds(0.125f, 0.0f, 0.125f, 0.875f, 0.375f, 0.875f);
        this.setStepSound(Block.soundTypeGrass);
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabGadgets);
        this.setHardness(3.0f);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.DOWN));
    }

    protected BlockState createBlockState() {
        return new BlockState((Block)this, new IProperty[]{FACING, NORTH, EAST, NORTHEAST, NORTHWEST});
    }

    public IBlockState getStateFromMeta(int meta) {
        if (meta >= EnumFacing.values().length) {
            meta = EnumFacing.DOWN.ordinal();
        }
        EnumFacing face = EnumFacing.values()[meta];
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)face);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).ordinal();
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)FACING);
        int off = -facing.ordinal() % 2;
        EnumFacing face1 = EnumFacing.values()[(facing.ordinal() + 2) % 6];
        EnumFacing face2 = EnumFacing.values()[(facing.ordinal() + 4 + off) % 6];
        IBlockState north = worldIn.getBlockState(pos.offset(face1));
        IBlockState east = worldIn.getBlockState(pos.offset(face2));
        if (north.getBlock() == this && north.getValue((IProperty)FACING) == facing) {
            state = state.withProperty((IProperty)NORTH, (Comparable)Boolean.valueOf(true));
        }
        if (east.getBlock() == this && east.getValue((IProperty)FACING) == facing) {
            state = state.withProperty((IProperty)EAST, (Comparable)Boolean.valueOf(true));
        }
        IBlockState northeast = worldIn.getBlockState(pos.offset(face1).offset(face2));
        IBlockState northwest = worldIn.getBlockState(pos.offset(face1).offset(face2.getOpposite()));
        if (northeast.getBlock() == this && northeast.getValue((IProperty)FACING) == facing) {
            state = state.withProperty((IProperty)NORTHEAST, (Comparable)Boolean.valueOf(true));
        }
        if (northwest.getBlock() == this && northwest.getValue((IProperty)FACING) == facing) {
            state = state.withProperty((IProperty)NORTHWEST, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = facing.getOpposite();
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumfacing);
    }

    public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.isSideSolid(pos.offset(side.getOpposite()), side, true);
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)FACING);
        if (!worldIn.isSideSolid(pos.offset(facing), facing.getOpposite(), true)) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
    }

    public void setBlockBoundsBasedOnState(IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)worldIn.getBlockState(pos).getValue((IProperty)FACING);
        this.setBlockBoundsBasedOnState(facing);
    }

    public void setBlockBoundsBasedOnState(EnumFacing facing) {
        float h = 0.375f;
        float xMin = 0.1875f;
        float xMax = 1.0f - xMin;
        float zMin = 0.1875f;
        float zMax = 1.0f - zMin;
        float yMin = 0.1875f;
        float yMax = 1.0f - yMin;
        switch (facing) {
            case DOWN: {
                yMin = 0.0f;
                yMax = h;
                break;
            }
            case UP: {
                yMin = 1.0f - h;
                yMax = 1.0f;
                break;
            }
            case SOUTH: {
                zMin = 1.0f - h;
                zMax = 1.0f;
                break;
            }
            case NORTH: {
                zMax = h;
                zMin = 0.0f;
                break;
            }
            case EAST: {
                xMin = 1.0f - h;
                xMax = 1.0f;
                break;
            }
            case WEST: {
                xMax = h;
                xMin = 0.0f;
            }
        }
        this.setBlockBounds(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public AxisAlignedBB getCollisionBoundingBox(World worldIn, BlockPos pos, IBlockState state) {
        this.setBlockBoundsBasedOnState((EnumFacing)state.getValue((IProperty)FACING));
        return super.getCollisionBoundingBox(worldIn, pos, state);
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityLiving) {
            float damage = 3.0f;
            if (entityIn.fallDistance > 0.0f) {
                damage += entityIn.fallDistance * 1.5f + 2.0f;
            }
            entityIn.attackEntityFrom(DamageSource.cactus, damage);
            ((EntityLiving)entityIn).addPotionEffect(new PotionEffect(Potion.moveSlowdown.getId(), 20, 1));
        }
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isFullCube() {
        return false;
    }

    private static enum Corner implements IStringSerializable
    {
        NONE_UP,
        NORTH_DOWN,
        EAST_UP,
        EAST_DOWN,
        SOUTH_UP,
        SOUTH_DOWN,
        WEST_UP,
        WEST_DOWN;


        public String getName() {
            return this.toString();
        }
    }
}

