/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.debug;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;

public class LocalizationCheckCommand
extends CommandBase {
    public int getRequiredPermissionLevel() {
        return 0;
    }

    public String getCommandName() {
        return "checkLocalizationStrings";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "/" + this.getCommandName() + " [Material-Identifier]";
    }

    public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length != 1) {
            return null;
        }
        LinkedList completions = Lists.newLinkedList();
        String matName = args[0].toLowerCase();
        for (Material mat : TinkerRegistry.getAllMaterials()) {
            if (!mat.identifier.toLowerCase().startsWith(matName)) continue;
            completions.add(mat.identifier);
        }
        return completions;
    }

    public void processCommand(ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 1) {
            throw new WrongUsageException(this.getCommandUsage(sender), new Object[0]);
        }
        if (args.length > 0) {
            Material mat = TinkerRegistry.getMaterial(args[0]);
            if (mat == Material.UNKNOWN) {
                throw new CommandException("Unknown material: " + args[0], new Object[0]);
            }
            this.scanMaterial(mat, sender);
        } else {
            for (Material mat : TinkerRegistry.getAllMaterials()) {
                this.scanMaterial(mat, sender);
            }
        }
    }

    private void scanMaterial(Material material, ICommandSender sender) {
        this.checkStr(String.format("material.%s.name", material.identifier), sender);
    }

    private void checkStr(String str, ICommandSender sender) {
        if (!StatCollector.canTranslate((String)str)) {
            sender.addChatMessage((IChatComponent)new ChatComponentText("Missing localization for name: " + str));
        }
    }
}

