/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.IWorldGenerator;
import slimeknights.tconstruct.world.TinkerWorld;

public class SlimeTreeGenerator
implements IWorldGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final IBlockState log;
    public final IBlockState leaves;
    public final IBlockState vine;
    public final boolean seekHeight;

    public SlimeTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, IBlockState vine, boolean seekHeight) {
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.log = log;
        this.leaves = leaves;
        this.vine = vine;
        this.seekHeight = seekHeight;
    }

    public SlimeTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, IBlockState vine) {
        this(treeHeight, treeRange, log, leaves, vine, true);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
    }

    public void generateTree(Random random, World world, BlockPos pos) {
        int height = random.nextInt(this.treeHeightRange) + this.minTreeHeight;
        boolean flag = true;
        if (this.seekHeight && (pos = this.findGround(world, pos)).getY() < 0) {
            return;
        }
        int yPos = pos.getY();
        if (yPos >= 1 && yPos + height + 1 <= 256) {
            boolean isSoil;
            Block soil = world.getBlockState(pos.down()).getBlock();
            boolean bl = isSoil = soil != null && soil.canSustainPlant((IBlockAccess)world, pos.down(), EnumFacing.UP, (IPlantable)TinkerWorld.slimeSapling);
            if (isSoil) {
                soil.onPlantGrow(world, pos.down(), pos);
                this.placeCanopy(world, random, pos, height);
                this.placeTrunk(world, pos, height);
            }
        }
    }

    BlockPos findGround(World world, BlockPos pos) {
        do {
            Block heightID;
            if ((heightID = world.getBlockState(pos).getBlock()) != TinkerWorld.slimeDirt && heightID != TinkerWorld.slimeGrass || world.getBlockState(pos.up()).getBlock().isOpaqueCube()) continue;
            return pos.up();
        } while ((pos = pos.down()).getY() > 0);
        return pos;
    }

    void placeCanopy(World world, Random random, BlockPos pos, int height) {
        pos = pos.up(height);
        for (int i = 0; i < 4; ++i) {
            this.placeDiamondLayer(world, pos.down(i), i + 1);
        }
        IBlockState air = Blocks.air.getDefaultState();
        pos = pos.down();
        this.setBlockAndMetadata(world, pos.add(4, 0, 0), air);
        this.setBlockAndMetadata(world, pos.add(-4, 0, 0), air);
        this.setBlockAndMetadata(world, pos.add(0, 0, 4), air);
        this.setBlockAndMetadata(world, pos.add(0, 0, -4), air);
        this.setBlockAndMetadata(world, pos.add(1, 0, 1), air);
        this.setBlockAndMetadata(world, pos.add(1, 0, -1), air);
        this.setBlockAndMetadata(world, pos.add(-1, 0, 1), air);
        this.setBlockAndMetadata(world, pos.add(-1, 0, -1), air);
        pos = pos.down();
        this.setBlockAndMetadata(world, pos.add(3, 0, 0), this.leaves);
        this.setBlockAndMetadata(world, pos.add(-3, 0, 0), this.leaves);
        this.setBlockAndMetadata(world, pos.add(0, 0, -3), this.leaves);
        this.setBlockAndMetadata(world, pos.add(0, 0, 3), this.leaves);
        this.setBlockAndMetadata(world, pos.add(2, 0, 2), this.leaves);
        this.setBlockAndMetadata(world, pos.add(2, 0, -2), this.leaves);
        this.setBlockAndMetadata(world, pos.add(-2, 0, 2), this.leaves);
        this.setBlockAndMetadata(world, pos.add(-2, 0, -2), this.leaves);
        pos = pos.down();
        this.setBlockAndMetadata(world, pos.add(3, 0, 0), this.leaves);
        this.setBlockAndMetadata(world, pos.add(-3, 0, 0), this.leaves);
        this.setBlockAndMetadata(world, pos.add(0, 0, -3), this.leaves);
        this.setBlockAndMetadata(world, pos.add(0, 0, 3), this.leaves);
        this.setBlockAndMetadata(world, pos.add(2, 0, 2), this.leaves);
        this.setBlockAndMetadata(world, pos.add(2, 0, -2), this.leaves);
        this.setBlockAndMetadata(world, pos.add(-2, 0, 2), this.leaves);
        this.setBlockAndMetadata(world, pos.add(-2, 0, -2), this.leaves);
        if (this.vine != null) {
            pos = pos.down();
            this.setBlockAndMetadata(world, pos.add(3, 0, 0), this.getRandomizedVine(random));
            this.setBlockAndMetadata(world, pos.add(-3, 0, 0), this.getRandomizedVine(random));
            this.setBlockAndMetadata(world, pos.add(0, 0, -3), this.getRandomizedVine(random));
            this.setBlockAndMetadata(world, pos.add(0, 0, 3), this.getRandomizedVine(random));
            this.setBlockAndMetadata(world, pos.add(2, 0, 2), this.getRandomizedVine(random));
            this.setBlockAndMetadata(world, pos.add(2, 0, -2), this.getRandomizedVine(random));
            this.setBlockAndMetadata(world, pos.add(-2, 0, 2), this.getRandomizedVine(random));
            this.setBlockAndMetadata(world, pos.add(-2, 0, -2), this.getRandomizedVine(random));
        }
    }

    protected IBlockState getRandomizedVine(Random random) {
        IBlockState state = this.vine;
        PropertyBool[] sides = new PropertyBool[]{BlockVine.NORTH, BlockVine.EAST, BlockVine.SOUTH, BlockVine.WEST};
        for (int i = random.nextInt(3) + 1; i > 0; --i) {
            state = state.withProperty((IProperty)sides[random.nextInt(sides.length)], (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void placeDiamondLayer(World world, BlockPos pos, int range) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) + Math.abs(z) > range) continue;
                this.setBlockAndMetadata(world, pos.add(x, 0, z), this.leaves);
            }
        }
    }

    protected void placeTrunk(World world, BlockPos pos, int height) {
        while (height >= 0) {
            Block block = world.getBlockState(pos).getBlock();
            if (block.isAir((IBlockAccess)world, pos) || block.isReplaceable(world, pos) || block.isLeaves((IBlockAccess)world, pos)) {
                this.setBlockAndMetadata(world, pos, this.log);
            }
            pos = pos.up();
            --height;
        }
    }

    protected void setBlockAndMetadata(World world, BlockPos pos, IBlockState state) {
        Block block = world.getBlockState(pos).getBlock();
        if (block.isAir((IBlockAccess)world, pos) || block.canPlaceBlockAt(world, pos) || world.getBlockState(pos) == this.leaves) {
            world.setBlockState(pos, state, 2);
        }
    }
}

