/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class BlockSlimeVine
extends BlockVine {
    protected final BlockSlimeGrass.FoliageType foliage;
    protected final BlockSlimeVine nextStage;

    public BlockSlimeVine(BlockSlimeGrass.FoliageType foliage, BlockSlimeVine nextStage) {
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabWorld);
        this.setStepSound(soundTypeGrass);
        this.foliage = foliage;
        this.nextStage = nextStage;
    }

    private Boolean canAttachTo(IBlockAccess world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        return block.isFullCube() && block.getMaterial().blocksMovement();
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.getDefaultState();
        iblockstate = iblockstate.withProperty((IProperty)NORTH, (Comparable)this.canAttachTo((IBlockAccess)worldIn, pos.north()));
        iblockstate = iblockstate.withProperty((IProperty)EAST, (Comparable)this.canAttachTo((IBlockAccess)worldIn, pos.east()));
        iblockstate = iblockstate.withProperty((IProperty)SOUTH, (Comparable)this.canAttachTo((IBlockAccess)worldIn, pos.south()));
        iblockstate = iblockstate.withProperty((IProperty)WEST, (Comparable)this.canAttachTo((IBlockAccess)worldIn, pos.west()));
        return iblockstate;
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (worldIn.isRemote) {
            return;
        }
        if (!(this.canAttachTo((IBlockAccess)worldIn, pos.north()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, pos.east()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, pos.south()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, pos.west()).booleanValue() || worldIn.getBlockState(pos.up()).getBlock() instanceof BlockVine)) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
        BlockPos down = pos.down();
        while (worldIn.getBlockState(down).getBlock() instanceof BlockVine) {
            worldIn.markBlockForUpdate(down);
            down = down.down();
        }
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.isRemote && rand.nextInt(4) == 0) {
            this.grow(worldIn, rand, pos, state);
        }
    }

    public void grow(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (this.nextStage == null) {
            return;
        }
        BlockPos below = pos.down();
        if (worldIn.isAirBlock(below)) {
            if (!(this.canAttachTo((IBlockAccess)worldIn, below.north()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, below.east()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, below.south()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, below.west()).booleanValue())) {
                int i = 0;
                while (worldIn.getBlockState(pos.up(i)).getBlock() == this) {
                    ++i;
                }
                if (i > 2 || rand.nextInt(2) == 0) {
                    state = this.nextStage.getDefaultState().withProperty((IProperty)NORTH, state.getValue((IProperty)NORTH)).withProperty((IProperty)EAST, state.getValue((IProperty)EAST)).withProperty((IProperty)SOUTH, state.getValue((IProperty)SOUTH)).withProperty((IProperty)WEST, state.getValue((IProperty)WEST));
                }
            }
            worldIn.setBlockState(below, state);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(IBlockState state) {
        return SlimeColorizer.getColorStatic(this.foliage);
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IBlockState state = worldIn.getBlockState(pos);
        if (state.getBlock() != this) {
            return this.getBlockColor();
        }
        return SlimeColorizer.getColorForPos(pos.add(128.0, 0.0, 128.0), this.foliage);
    }
}

