/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.traits.AbstractTrait;

public class TraitAridiculous
extends AbstractTrait {
    public TraitAridiculous() {
        super("aridiculous", EnumChatFormatting.DARK_RED);
    }

    @Override
    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        float coeff = this.calcAridiculousness(event.entityPlayer.worldObj, event.pos) / 10.0f;
        event.newSpeed += event.originalSpeed * coeff;
    }

    @Override
    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        float extraDamage = 2.0f * this.calcAridiculousness(player.worldObj, player.getPosition());
        return extraDamage + super.damage(tool, player, target, damage, newDamage, isCritical);
    }

    protected float calcAridiculousness(World world, BlockPos pos) {
        BiomeGenBase biome = world.getBiomeGenForCoords(pos);
        float rain = world.isRaining() ? biome.getFloatRainfall() / 2.0f : 0.0f;
        return (float)(Math.pow(1.25, 3.0 * (double)(0.5f + biome.temperature - biome.rainfall)) - 1.25) - rain;
    }
}

