/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.BroadSword;

public class LongSword
extends BroadSword {
    public LongSword() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.swordBlade), PartMaterialType.extra(TinkerTools.handGuard));
    }

    @Override
    public float damagePotential() {
        return 1.13f;
    }

    @Override
    public int attackSpeed() {
        return 0;
    }

    @Override
    public float damageCutoff() {
        return 18.0f;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.NONE;
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.preventSlowDown(entityIn, 0.9f);
        super.onUpdate(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
        int time = this.getMaxItemUseDuration(stack) - timeLeft;
        if (time > 5) {
            player.addExhaustion(0.2f);
            player.setSprinting(true);
            float increase = (float)(0.02 * (double)time + 0.2);
            if (increase > 0.56f) {
                increase = 0.56f;
            }
            player.motionY += (double)increase;
            float speed = 0.05f * (float)time;
            if (speed > 0.925f) {
                speed = 0.925f;
            }
            player.motionX = -MathHelper.sin((float)(player.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(player.rotationPitch / 180.0f * (float)Math.PI)) * speed;
            player.motionZ = MathHelper.cos((float)(player.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(player.rotationPitch / 180.0f * (float)Math.PI)) * speed;
        }
        super.onPlayerStoppedUsing(stack, world, player, timeLeft);
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        ToolNBT data = this.buildDefaultTag(materials);
        data.attack += 1.0f;
        data.attack = Math.max(1.0f, data.attack);
        return data.get();
    }
}

