/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.BroadSword;
import slimeknights.tconstruct.tools.network.EntityMovementChangePacket;

public class BattleSign
extends BroadSword {
    public BattleSign() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.signHead));
    }

    @Override
    public int attackSpeed() {
        return 0;
    }

    @Override
    public float damagePotential() {
        return 0.86f;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void reducedDamageBlocked(LivingHurtEvent event) {
        if (event.source.isUnblockable() || event.source.isMagicDamage() || event.source.isExplosion() || event.source.isProjectile() || event.isCanceled()) {
            return;
        }
        if (!this.shouldBlockDamage((Entity)event.entityLiving)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        ItemStack battlesign = player.getCurrentEquippedItem();
        int damage = event.ammount < 2.0f ? 1 : Math.round(event.ammount / 2.0f);
        event.ammount *= 0.7f;
        if (event.source.getEntity() != null) {
            event.source.getEntity().attackEntityFrom(DamageSource.causeThornsDamage((Entity)player), event.ammount / 2.0f);
            damage = damage * 3 / 2;
        }
        ToolHelper.damageTool(battlesign, damage, (EntityLivingBase)player);
    }

    @SubscribeEvent
    public void reflectProjectiles(LivingAttackEvent event) {
        if (event.source.isUnblockable() || !event.source.isProjectile()) {
            return;
        }
        if (!this.shouldBlockDamage((Entity)event.entityLiving)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        ItemStack battlesign = player.getCurrentEquippedItem();
        Entity projectile = event.source.getSourceOfDamage();
        Vec3 motion = new Vec3(projectile.motionX, projectile.motionY, projectile.motionZ);
        Vec3 look = player.getLookVec();
        double strength = -look.dotProduct(motion.normalize());
        if (strength < 0.1) {
            return;
        }
        event.setCanceled(true);
        double speed = projectile.motionX * projectile.motionX + projectile.motionY * projectile.motionY + projectile.motionZ * projectile.motionZ;
        speed = Math.sqrt(speed);
        projectile.motionX = look.xCoord * (speed += (double)0.2f);
        projectile.motionY = look.yCoord * speed;
        projectile.motionZ = look.zCoord * speed;
        projectile.rotationYaw = (float)(Math.atan2(projectile.motionX, projectile.motionZ) * 180.0 / Math.PI);
        projectile.rotationPitch = (float)(Math.atan2(projectile.motionY, speed) * 180.0 / Math.PI);
        TinkerNetwork.sendToAll((AbstractPacket)new EntityMovementChangePacket(projectile));
        if (projectile instanceof EntityArrow) {
            ((EntityArrow)projectile).shootingEntity = player;
            projectile.motionX /= (double)-0.1f;
            projectile.motionY /= (double)-0.1f;
            projectile.motionZ /= (double)-0.1f;
        }
        ToolHelper.damageTool(battlesign, (int)event.ammount, (EntityLivingBase)player);
    }

    protected boolean shouldBlockDamage(Entity entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!player.isBlocking() || player.getCurrentEquippedItem().getItem() != this) {
            return false;
        }
        return !ToolHelper.isBroken(player.getCurrentEquippedItem());
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        return this.buildDefaultTag(materials).get();
    }
}

