/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.inventory;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.IContainerCraftingCustom;
import slimeknights.mantle.inventory.SlotCraftingCustom;
import slimeknights.mantle.inventory.SlotOut;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.shared.inventory.InventoryCraftingPersistent;
import slimeknights.tconstruct.tools.block.BlockToolTable;
import slimeknights.tconstruct.tools.client.GuiPartBuilder;
import slimeknights.tconstruct.tools.inventory.ContainerPatternChest;
import slimeknights.tconstruct.tools.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.inventory.SlotStencil;
import slimeknights.tconstruct.tools.tileentity.TilePartBuilder;
import slimeknights.tconstruct.tools.tileentity.TilePatternChest;

public class ContainerPartBuilder
extends ContainerTinkerStation<TilePartBuilder>
implements IContainerCraftingCustom {
    public IInventory craftResult;
    private final Slot patternSlot;
    private final Slot secondarySlot;
    private final Slot input1;
    private final Slot input2;
    private final boolean partCrafter;
    public final IInventory patternChest;

    public ContainerPartBuilder(InventoryPlayer playerInventory, TilePartBuilder tile) {
        super(tile);
        InventoryCraftingPersistent craftMatrix = new InventoryCraftingPersistent((Container)this, (IInventory)tile, 1, 3);
        this.craftResult = new InventoryCraftResult();
        this.addSlotToContainer((Slot)new SlotCraftingCustom((IContainerCraftingCustom)this, playerInventory.player, (InventoryCrafting)craftMatrix, this.craftResult, 0, 106, 35));
        this.secondarySlot = new SlotOut((IInventory)tile, 3, 132, 35);
        this.addSlotToContainer(this.secondarySlot);
        this.patternSlot = new SlotStencil((IInventory)craftMatrix, 2, 26, 35);
        this.addSlotToContainer(this.patternSlot);
        this.input1 = new Slot((IInventory)craftMatrix, 0, 48, 26);
        this.addSlotToContainer(this.input1);
        this.input2 = new Slot((IInventory)craftMatrix, 1, 48, 44);
        this.addSlotToContainer(this.input2);
        TilePatternChest chest = (TilePatternChest)this.detectTE(TilePatternChest.class);
        if (chest != null) {
            boolean hasCraftingStation = false;
            boolean hasStencilTable = false;
            for (Pair pair : this.tinkerStationBlocks) {
                BlockToolTable.TableTypes type;
                if (!((IBlockState)pair.getRight()).getProperties().containsKey(BlockToolTable.TABLES) || (type = (BlockToolTable.TableTypes)((Object)((IBlockState)pair.getRight()).getValue(BlockToolTable.TABLES))) == null) continue;
                if (type == BlockToolTable.TableTypes.CraftingStation) {
                    hasCraftingStation = true;
                    continue;
                }
                if (type != BlockToolTable.TableTypes.StencilTable) continue;
                hasStencilTable = true;
            }
            this.partCrafter = hasStencilTable && hasCraftingStation;
            ContainerPatternChest.DynamicChestInventory sideInventory = new ContainerPatternChest.DynamicChestInventory(chest, (IInventory)chest, -6, 8, 6);
            this.addSubContainer((Container)sideInventory, true);
            this.patternChest = chest;
        } else {
            this.partCrafter = false;
            this.patternChest = null;
        }
        this.addPlayerInventory(playerInventory, 8, 84);
        this.onCraftMatrixChanged(null);
    }

    public boolean isPartCrafter() {
        return this.partCrafter;
    }

    public void onCraftMatrixChanged(IInventory inventoryIn) {
        this.updateResult();
    }

    public void updateResult() {
        if (!this.patternSlot.getHasStack() || !this.input1.getHasStack() && !this.input2.getHasStack() && !this.secondarySlot.getHasStack()) {
            this.craftResult.setInventorySlotContents(0, null);
            this.updateGUI();
        } else {
            ItemStack[] toolPart;
            TinkerGuiException throwable = null;
            try {
                toolPart = ToolBuilder.tryBuildToolPart(this.patternSlot.getStack(), new ItemStack[]{this.input1.getStack(), this.input2.getStack()}, false);
            }
            catch (TinkerGuiException e) {
                toolPart = null;
                throwable = e;
            }
            ItemStack secondary = this.secondarySlot.getStack();
            if (toolPart != null && (secondary == null || toolPart[1] == null || ItemStack.areItemsEqual((ItemStack)secondary, (ItemStack)toolPart[1]) && ItemStack.areItemStackTagsEqual((ItemStack)secondary, (ItemStack)toolPart[1]))) {
                this.craftResult.setInventorySlotContents(0, toolPart[0]);
            } else {
                this.craftResult.setInventorySlotContents(0, null);
            }
            if (throwable != null) {
                this.error(throwable.getMessage());
            } else {
                this.updateGUI();
            }
        }
    }

    public void setPattern(ItemStack wanted) {
        if (this.patternChest == null) {
            return;
        }
        for (int i = 0; i < this.patternChest.getSizeInventory(); ++i) {
            if (!ItemStack.areItemStacksEqual((ItemStack)wanted, (ItemStack)this.patternChest.getStackInSlot(i))) continue;
            ItemStack slotStack = this.patternSlot.getStack();
            this.patternSlot.putStack(this.patternChest.getStackInSlot(i));
            this.patternChest.setInventorySlotContents(i, slotStack);
            break;
        }
    }

    public void onCrafting(EntityPlayer player, ItemStack output, IInventory craftMatrix) {
        ItemStack[] toolPart = new ItemStack[]{};
        try {
            toolPart = ToolBuilder.tryBuildToolPart(this.patternSlot.getStack(), new ItemStack[]{this.input1.getStack(), this.input2.getStack()}, true);
        }
        catch (TinkerGuiException tinkerGuiException) {
            // empty catch block
        }
        if (toolPart == null) {
            return;
        }
        ItemStack secondary = this.secondarySlot.getStack();
        if (secondary == null) {
            this.putStackInSlot(this.secondarySlot.slotNumber, toolPart[1]);
        } else if (toolPart[1] != null && ItemStack.areItemsEqual((ItemStack)secondary, (ItemStack)toolPart[1]) && ItemStack.areItemStackTagsEqual((ItemStack)secondary, (ItemStack)toolPart[1])) {
            secondary.stackSize += toolPart[1].stackSize;
        }
        for (int i = 0; i < craftMatrix.getSizeInventory(); ++i) {
            if (craftMatrix.getStackInSlot(i) == null || craftMatrix.getStackInSlot((int)i).stackSize != 0) continue;
            craftMatrix.setInventorySlotContents(i, null);
        }
        this.updateResult();
    }

    public boolean canMergeSlot(ItemStack p_94530_1_, Slot p_94530_2_) {
        return p_94530_2_.inventory != this.craftResult && super.canMergeSlot(p_94530_1_, p_94530_2_);
    }

    public IChatComponent getInventoryDisplayName() {
        if (this.partCrafter) {
            return new ChatComponentTranslation("gui.partcrafter.name", new Object[0]);
        }
        return super.getInventoryDisplayName();
    }

    @SideOnly(value=Side.CLIENT)
    public void putStackInSlot(int p_75141_1_, ItemStack p_75141_2_) {
        super.putStackInSlot(p_75141_1_, p_75141_2_);
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.currentScreen instanceof GuiPartBuilder) {
            ((GuiPartBuilder)mc.currentScreen).updateButtons();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack slotClick(int slotId, int clickedButton, int mode, EntityPlayer playerIn) {
        ItemStack ret = super.slotClick(slotId, clickedButton, mode, playerIn);
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.currentScreen instanceof GuiPartBuilder) {
            ((GuiPartBuilder)mc.currentScreen).updateButtons();
        }
        return ret;
    }
}

