/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.events.TinkerToolEvent;
import slimeknights.tconstruct.tools.network.ToolBreakAnimationPacket;

public final class ToolHelper {
    private ToolHelper() {
    }

    public static boolean hasCategory(ItemStack stack, Category category) {
        if (stack == null || stack.getItem() == null || !(stack.getItem() instanceof TinkersItem)) {
            return false;
        }
        return ((TinkersItem)stack.getItem()).hasCategory(category);
    }

    public static int getDurabilityStat(ItemStack stack) {
        return ToolHelper.getIntTag(stack, "Durability");
    }

    public static int getHarvestLevelStat(ItemStack stack) {
        return ToolHelper.getIntTag(stack, "HarvestLevel");
    }

    public static float getMiningSpeedStat(ItemStack stack) {
        return ToolHelper.getfloatTag(stack, "MiningSpeed");
    }

    public static float getAttackStat(ItemStack stack) {
        return ToolHelper.getfloatTag(stack, "Attack");
    }

    public static float getActualAttack(ItemStack stack) {
        float damage = ToolHelper.getAttackStat(stack);
        if (stack != null && stack.getItem() instanceof ToolCore) {
            damage *= ((ToolCore)stack.getItem()).damagePotential();
        }
        return damage;
    }

    public static float getActualMiningSpeed(ItemStack stack) {
        float speed = ToolHelper.getMiningSpeedStat(stack);
        if (stack != null && stack.getItem() instanceof ToolCore) {
            speed *= ((ToolCore)stack.getItem()).miningSpeedModifier();
        }
        return speed;
    }

    public static int getFreeModifiers(ItemStack stack) {
        return ToolHelper.getIntTag(stack, "FreeModifiers");
    }

    public static List<ITrait> getTraits(ItemStack stack) {
        LinkedList traits = Lists.newLinkedList();
        NBTTagList traitsTagList = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < traitsTagList.tagCount(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(traitsTagList.getStringTagAt(i));
            if (trait == null) continue;
            traits.add(trait);
        }
        return traits;
    }

    public static float calcDigSpeed(ItemStack stack, IBlockState blockState) {
        if (blockState == null) {
            return 0.0f;
        }
        if (!stack.hasTagCompound()) {
            return 1.0f;
        }
        if (!ToolHelper.canHarvest(stack, blockState)) {
            return 0.0f;
        }
        if (ToolHelper.isBroken(stack)) {
            return 0.3f;
        }
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        float strength = stack.getItem().getStrVsBlock(stack, blockState.getBlock());
        float speed = tag.getFloat("MiningSpeed");
        if (stack.getItem() instanceof ToolCore) {
            speed *= ((ToolCore)stack.getItem()).miningSpeedModifier();
        }
        return strength * speed;
    }

    public static boolean isToolEffective(ItemStack stack, IBlockState state) {
        for (String type : stack.getItem().getToolClasses(stack)) {
            if (!state.getBlock().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToolEffective2(ItemStack stack, IBlockState state) {
        if (ToolHelper.isToolEffective(stack, state)) {
            return true;
        }
        return stack.getItem() instanceof ToolCore && ((ToolCore)stack.getItem()).isEffective(state.getBlock());
    }

    public static boolean canHarvest(ItemStack stack, IBlockState state) {
        Block block = state.getBlock();
        if (block.getMaterial().isToolNotRequired()) {
            return true;
        }
        String type = block.getHarvestTool(state);
        int level = block.getHarvestLevel(state);
        return stack.getItem().getHarvestLevel(stack, type) >= level;
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin, int width, int height, int depth) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, width, height, depth, -1);
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin, int width, int height, int depth, int distance) {
        int z;
        int y;
        int x;
        if (stack == null || !(stack.getItem() instanceof ToolCore)) {
            return ImmutableList.of();
        }
        IBlockState state = world.getBlockState(origin);
        Block block = state.getBlock();
        if (block.getMaterial() == Material.air) {
            return ImmutableList.of();
        }
        MovingObjectPosition mop = ((ToolCore)stack.getItem()).getMovingObjectPositionFromPlayer(world, player, false);
        if (mop == null) {
            return ImmutableList.of();
        }
        TinkerToolEvent.ExtraBlockBreak event = TinkerToolEvent.ExtraBlockBreak.fireEvent(stack, player, width, height, depth, distance);
        width = event.width;
        height = event.height;
        depth = event.depth;
        distance = event.distance;
        BlockPos start = origin;
        switch (mop.sideHit) {
            case DOWN: 
            case UP: {
                Vec3i vec = player.getHorizontalFacing().getDirectionVec();
                x = vec.getX() * height + vec.getZ() * width;
                y = mop.sideHit.getAxisDirection().getOffset() * -depth;
                z = vec.getX() * width + vec.getZ() * height;
                start = start.add(-x / 2, 0, -z / 2);
                if (x % 2 == 0) {
                    if (x > 0 && mop.hitVec.xCoord - (double)mop.getBlockPos().getX() > 0.5) {
                        start = start.add(1, 0, 0);
                    } else if (x < 0 && mop.hitVec.xCoord - (double)mop.getBlockPos().getX() < 0.5) {
                        start = start.add(-1, 0, 0);
                    }
                }
                if (z % 2 != 0) break;
                if (z > 0 && mop.hitVec.zCoord - (double)mop.getBlockPos().getZ() > 0.5) {
                    start = start.add(0, 0, 1);
                    break;
                }
                if (z >= 0 || !(mop.hitVec.zCoord - (double)mop.getBlockPos().getZ() < 0.5)) break;
                start = start.add(0, 0, -1);
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = width;
                y = height;
                z = mop.sideHit.getAxisDirection().getOffset() * -depth;
                start = start.add(-x / 2, -y / 2, 0);
                if (x % 2 == 0 && mop.hitVec.xCoord - (double)mop.getBlockPos().getX() > 0.5) {
                    start = start.add(1, 0, 0);
                }
                if (y % 2 != 0 || !(mop.hitVec.yCoord - (double)mop.getBlockPos().getY() > 0.5)) break;
                start = start.add(0, 1, 0);
                break;
            }
            case WEST: 
            case EAST: {
                x = mop.sideHit.getAxisDirection().getOffset() * -depth;
                y = height;
                z = width;
                start = start.add(0, -y / 2, -z / 2);
                if (y % 2 == 0 && mop.hitVec.yCoord - (double)mop.getBlockPos().getY() > 0.5) {
                    start = start.add(0, 1, 0);
                }
                if (z % 2 != 0 || !(mop.hitVec.zCoord - (double)mop.getBlockPos().getZ() > 0.5)) break;
                start = start.add(0, 0, 1);
                break;
            }
            default: {
                z = 0;
                y = 0;
                x = 0;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int xp = start.getX(); xp != start.getX() + x; xp += x / MathHelper.abs_int((int)x)) {
            for (int yp = start.getY(); yp != start.getY() + y; yp += y / MathHelper.abs_int((int)y)) {
                for (int zp = start.getZ(); zp != start.getZ() + z; zp += z / MathHelper.abs_int((int)z)) {
                    BlockPos pos;
                    if (xp == origin.getX() && yp == origin.getY() && zp == origin.getZ() || distance > 0 && MathHelper.abs_int((int)(xp - origin.getX())) + MathHelper.abs_int((int)(yp - origin.getY())) + MathHelper.abs_int((int)(zp - origin.getZ())) > distance || !ToolHelper.isToolEffective2(stack, world.getBlockState(pos = new BlockPos(xp, yp, zp)))) continue;
                    builder.add((Object)pos);
                }
            }
        }
        return builder.build();
    }

    public static void breakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        if (world.isAirBlock(pos)) {
            return;
        }
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (!ToolHelper.isToolEffective2(stack, state)) {
            return;
        }
        IBlockState refState = world.getBlockState(refPos);
        float refStrength = ForgeHooks.blockStrength((IBlockState)refState, (EntityPlayer)player, (World)world, (BlockPos)refPos);
        float strength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return;
        }
        if (player.capabilities.isCreativeMode) {
            block.onBlockHarvested(world, pos, state, player);
            if (block.removedByPlayer(world, pos, player, false)) {
                block.onBlockDestroyedByPlayer(world, pos, state);
            }
            if (!world.isRemote) {
                ((EntityPlayerMP)player).playerNetServerHandler.sendPacket((Packet)new S23PacketBlockChange(world, pos));
            }
            return;
        }
        stack.onBlockDestroyed(world, block, pos, player);
        if (!world.isRemote) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)((EntityPlayerMP)player).theItemInWorldManager.getGameType(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
            if (xp == -1) {
                return;
            }
            block.onBlockHarvested(world, pos, state, player);
            if (block.removedByPlayer(world, pos, player, true)) {
                block.onBlockDestroyedByPlayer(world, pos, state);
                block.harvestBlock(world, player, pos, state, world.getTileEntity(pos));
                block.dropXpOnBlockBreak(world, pos, xp);
            }
            EntityPlayerMP mpPlayer = (EntityPlayerMP)player;
            mpPlayer.playerNetServerHandler.sendPacket((Packet)new S23PacketBlockChange(world, pos));
        } else {
            PlayerControllerMP pcmp = Minecraft.getMinecraft().playerController;
            world.playAuxSFX(2001, pos, Block.getStateId((IBlockState)state));
            if (block.removedByPlayer(world, pos, player, true)) {
                block.onBlockDestroyedByPlayer(world, pos, state);
            }
            stack.onBlockDestroyed(world, block, pos, player);
            if (stack.stackSize == 0 && stack == player.getCurrentEquippedItem()) {
                player.destroyCurrentEquippedItem();
            }
            Minecraft.getMinecraft().getNetHandler().addToSendQueue((Packet)new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.getMinecraft().objectMouseOver.sideHit));
        }
    }

    public static boolean shearBlock(ItemStack itemstack, World world, EntityPlayer player, BlockPos pos) {
        IShearable target;
        if (world.isRemote) {
            return false;
        }
        Block block = world.getBlockState(pos).getBlock();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)world, pos)) {
            int fortune = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fortune.effectId, (ItemStack)itemstack);
            List drops = target.onSheared(itemstack, (IBlockAccess)world, pos, fortune);
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.worldObj, (double)pos.getX() + d, (double)pos.getY() + d1, (double)pos.getZ() + d2, stack);
                entityitem.setDefaultPickupDelay();
                world.spawnEntityInWorld((Entity)entityitem);
            }
            itemstack.damageItem(1, (EntityLivingBase)player);
            player.addStat(StatList.mineBlockStatArray[Block.getIdFromBlock((Block)block)], 1);
            world.setBlockToAir(pos);
            return true;
        }
        return false;
    }

    public static int getCurrentDurability(ItemStack stack) {
        return stack.getMaxDamage() - stack.getItemDamage();
    }

    public static void damageTool(ItemStack stack, int amount, EntityLivingBase entity) {
        if (amount == 0 || ToolHelper.isBroken(stack)) {
            return;
        }
        int actualAmount = amount;
        NBTTagList list = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < list.tagCount(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(list.getStringTagAt(i));
            if (trait == null) continue;
            actualAmount = amount > 0 ? trait.onToolDamage(stack, amount, actualAmount, entity) : trait.onToolHeal(stack, amount, actualAmount, entity);
        }
        actualAmount = Math.min(actualAmount, ToolHelper.getCurrentDurability(stack));
        stack.setItemDamage(stack.getItemDamage() + actualAmount);
        if (ToolHelper.getCurrentDurability(stack) == 0) {
            ToolHelper.breakTool(stack, entity);
        }
    }

    public static void healTool(ItemStack stack, int amount, EntityLivingBase entity) {
        ToolHelper.damageTool(stack, -amount, entity);
    }

    public static boolean isBroken(ItemStack stack) {
        return TagUtil.getToolTag(stack).getBoolean("Broken");
    }

    public static void breakTool(ItemStack stack, EntityLivingBase entity) {
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        tag.setBoolean("Broken", true);
        TagUtil.setToolTag(stack, tag);
        if (entity instanceof EntityPlayerMP) {
            TinkerNetwork.sendTo((AbstractPacket)new ToolBreakAnimationPacket(stack), (EntityPlayerMP)entity);
        }
    }

    public static void repairTool(ItemStack stack, int amount) {
        ToolHelper.repairTool(stack, amount, null);
    }

    public static void repairTool(ItemStack stack, int amount, EntityLivingBase entity) {
        if (ToolHelper.isBroken(stack)) {
            stack.setItemDamage(stack.getMaxDamage());
            NBTTagCompound tag = TagUtil.getToolTag(stack);
            tag.setBoolean("Broken", false);
            TagUtil.setToolTag(stack, tag);
        }
        TinkerToolEvent.OnRepair.fireEvent(stack, amount);
        ToolHelper.healTool(stack, amount, entity);
    }

    public static boolean attackEntity(ItemStack stack, ToolCore tool, EntityPlayer player, Entity targetEntity) {
        if (targetEntity == null || !targetEntity.canAttackWithItem() || targetEntity.hitByEntity((Entity)player) || !stack.hasTagCompound()) {
            return false;
        }
        if (!(targetEntity instanceof EntityLivingBase)) {
            return false;
        }
        if (ToolHelper.isBroken(stack)) {
            return false;
        }
        EntityLivingBase target = (EntityLivingBase)targetEntity;
        LinkedList traits = Lists.newLinkedList();
        NBTTagList traitsTagList = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < traitsTagList.tagCount(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(traitsTagList.getStringTagAt(i));
            if (trait == null) continue;
            traits.add(trait);
        }
        float baseDamage = (float)player.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        float baseKnockback = player.isSprinting() ? 1.0f : 0.0f;
        baseDamage += ToolHelper.getAttackStat(stack);
        baseDamage *= tool.damagePotential();
        boolean isCritical = player.fallDistance > 0.0f && !player.onGround && !player.isOnLadder() && !player.isInWater() && !player.isPotionActive(Potion.blindness) && player.ridingEntity == null && targetEntity instanceof EntityLivingBase;
        for (Object trait : traits) {
            if (!trait.isCriticalHit(stack, (EntityLivingBase)player, target)) continue;
            isCritical = true;
        }
        float damage = baseDamage;
        for (Object trait : traits) {
            damage = trait.damage(stack, (EntityLivingBase)player, target, baseDamage, damage, isCritical);
        }
        if (isCritical) {
            damage *= 1.5f;
        }
        damage = ToolHelper.calcCutoffDamage(damage, tool.damageCutoff());
        float knockback = baseKnockback;
        for (ITrait trait : traits) {
            knockback = trait.knockBack(stack, (EntityLivingBase)player, target, damage, baseKnockback, knockback, isCritical);
        }
        float oldHP = target.getHealth();
        double oldVelX = target.motionX;
        double oldVelY = target.motionY;
        double oldVelZ = target.motionZ;
        int hurtResistantTime = target.hurtResistantTime;
        for (ITrait trait : traits) {
            trait.onHit(stack, (EntityLivingBase)player, target, damage, isCritical);
            target.hurtResistantTime = hurtResistantTime;
        }
        boolean hit = tool.dealDamage(stack, player, target, damage);
        if (hit) {
            float damageDealt = oldHP - target.getHealth();
            oldVelX = target.motionX = oldVelX + (target.motionX - oldVelX) * (double)tool.knockback();
            oldVelY = target.motionY = oldVelY + (target.motionY - oldVelY) * (double)tool.knockback() / 3.0;
            oldVelZ = target.motionZ = oldVelZ + (target.motionZ - oldVelZ) * (double)tool.knockback();
            if (knockback > 0.0f) {
                double velX = -MathHelper.sin((float)(player.rotationYaw * (float)Math.PI / 180.0f)) * knockback * 0.5f;
                double velZ = MathHelper.cos((float)(player.rotationYaw * (float)Math.PI / 180.0f)) * knockback * 0.5f;
                targetEntity.addVelocity(velX, 0.1, velZ);
                player.motionX *= (double)0.6f;
                player.motionZ *= (double)0.6f;
                player.setSprinting(false);
            }
            if (targetEntity instanceof EntityPlayerMP && targetEntity.velocityChanged) {
                ((EntityPlayerMP)targetEntity).playerNetServerHandler.sendPacket((Packet)new S12PacketEntityVelocity(targetEntity));
                targetEntity.velocityChanged = false;
                targetEntity.motionX = oldVelX;
                targetEntity.motionY = oldVelY;
                targetEntity.motionZ = oldVelZ;
            }
            if (isCritical) {
                player.onCriticalHit((Entity)target);
            }
            if (damage > baseDamage) {
                player.onEnchantmentCritical(targetEntity);
            }
            if (damage >= 18.0f) {
                player.triggerAchievement((StatBase)AchievementList.overkill);
            }
            player.setLastAttacker((Entity)target);
            for (ITrait trait : traits) {
                trait.afterHit(stack, (EntityLivingBase)player, target, damageDealt, isCritical, hit);
            }
            stack.hitEntity(target, player);
            if (!player.capabilities.isCreativeMode) {
                tool.reduceDurabilityOnHit(stack, player, damage);
            }
            player.addStat(StatList.damageDealtStat, Math.round(damage * 10.0f));
            player.addExhaustion(0.3f);
        }
        return true;
    }

    public static float calcCutoffDamage(float damage, float cutoff) {
        float p = 1.0f;
        float d = damage;
        damage = 0.0f;
        while (d > cutoff) {
            damage += p * cutoff;
            if (p > 0.001f) {
                p *= 0.9f;
            } else {
                return damage += p * cutoff * (d / cutoff - 1.0f);
            }
            d -= cutoff;
        }
        return damage += p * d;
    }

    public static float getActualDamage(ItemStack stack, EntityPlayer player) {
        float damage = (float)player.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        damage += ToolHelper.getActualAttack(stack);
        if (stack.getItem() instanceof ToolCore) {
            damage = ToolHelper.calcCutoffDamage(damage, ((ToolCore)stack.getItem()).damageCutoff());
        }
        return damage;
    }

    public static void swingItem(int speed, EntityLivingBase entity) {
        if (!entity.isSwingInProgress || entity.swingProgressInt >= 3 || entity.swingProgressInt < 0) {
            entity.swingProgressInt = Math.min(4, -1 + speed);
            entity.isSwingInProgress = true;
            if (entity.worldObj instanceof WorldServer) {
                ((WorldServer)entity.worldObj).getEntityTracker().sendToAllTrackingEntity((Entity)entity, (Packet)new S0BPacketAnimation((Entity)entity, 0));
            }
        }
    }

    public static boolean useSecondaryItem(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        int slot = ToolHelper.getSecondaryItemSlot(player);
        if (slot == player.inventory.currentItem) {
            return false;
        }
        ItemStack secondaryItem = player.inventory.getStackInSlot(slot);
        if (secondaryItem == null) {
            return false;
        }
        int oldSlot = player.inventory.currentItem;
        player.inventory.currentItem = slot;
        boolean ret = secondaryItem.onItemUse(player, world, pos, side, hitX, hitY, hitZ);
        if (secondaryItem.stackSize == 0) {
            player.inventory.setInventorySlotContents(slot, null);
        }
        player.inventory.currentItem = oldSlot;
        return ret;
    }

    public static int getSecondaryItemSlot(EntityPlayer player) {
        ItemStack secondaryItem;
        int slot = player.inventory.currentItem;
        int max = InventoryPlayer.getHotbarSize() - 1;
        if (slot < max) {
            ++slot;
        }
        while (slot < max && ((secondaryItem = player.inventory.getStackInSlot(slot)) == null || secondaryItem.getItem() instanceof ToolCore && ((ToolCore)secondaryItem.getItem()).canUseSecondaryItem())) {
            ++slot;
        }
        secondaryItem = player.inventory.getStackInSlot(slot);
        if (secondaryItem != null && secondaryItem.getItem() instanceof ToolCore && ((ToolCore)secondaryItem.getItem()).canUseSecondaryItem()) {
            return player.inventory.currentItem;
        }
        return slot;
    }

    static int getIntTag(ItemStack stack, String key) {
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        return tag.getInteger(key);
    }

    static float getfloatTag(ItemStack stack, String key) {
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        return tag.getFloat(key);
    }
}

