/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.BlockPos;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tools.ToolNBT;

public final class TagUtil {
    public static int TAG_TYPE_STRING = new NBTTagString().getId();
    public static int TAG_TYPE_COMPOUND = new NBTTagCompound().getId();

    private TagUtil() {
    }

    public static NBTTagCompound getTagSafe(ItemStack stack) {
        if (stack == null || stack.getItem() == null || !stack.hasTagCompound()) {
            return new NBTTagCompound();
        }
        return stack.getTagCompound();
    }

    public static NBTTagCompound getTagSafe(NBTTagCompound tag, String key) {
        if (tag == null || !tag.hasKey(key)) {
            return new NBTTagCompound();
        }
        return tag.getCompoundTag(key);
    }

    public static NBTTagList getTagListSafe(NBTTagCompound tag, String key, int type) {
        if (tag == null || !tag.hasKey(key)) {
            return new NBTTagList();
        }
        return tag.getTagList(key, type);
    }

    public static NBTTagCompound getBaseTag(ItemStack stack) {
        return TagUtil.getBaseTag(TagUtil.getTagSafe(stack));
    }

    public static NBTTagCompound getBaseTag(NBTTagCompound root) {
        return TagUtil.getTagSafe(root, "TinkerData");
    }

    public static void setBaseTag(ItemStack stack, NBTTagCompound tag) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setBaseTag(root, tag);
        stack.setTagCompound(root);
    }

    public static void setBaseTag(NBTTagCompound root, NBTTagCompound tag) {
        if (root != null) {
            root.setTag("TinkerData", (NBTBase)tag);
        }
    }

    public static NBTTagList getBaseModifiersTagList(ItemStack stack) {
        return TagUtil.getBaseModifiersTagList(TagUtil.getTagSafe(stack));
    }

    public static NBTTagList getBaseModifiersTagList(NBTTagCompound root) {
        return TagUtil.getTagListSafe(TagUtil.getBaseTag(root), "Modifiers", TAG_TYPE_STRING);
    }

    public static void setBaseModifiersTagList(ItemStack stack, NBTTagList tagList) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setBaseModifiersTagList(root, tagList);
        stack.setTagCompound(root);
    }

    public static void setBaseModifiersTagList(NBTTagCompound root, NBTTagList tagList) {
        TagUtil.getBaseTag(root).setTag("Modifiers", (NBTBase)tagList);
    }

    public static NBTTagList getBaseMaterialsTagList(ItemStack stack) {
        return TagUtil.getBaseMaterialsTagList(TagUtil.getTagSafe(stack));
    }

    public static NBTTagList getBaseMaterialsTagList(NBTTagCompound root) {
        return TagUtil.getTagListSafe(TagUtil.getBaseTag(root), "Materials", TAG_TYPE_STRING);
    }

    public static void setBaseMaterialsTagList(ItemStack stack, NBTTagList tagList) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setBaseMaterialsTagList(root, tagList);
        stack.setTagCompound(root);
    }

    public static void setBaseMaterialsTagList(NBTTagCompound root, NBTTagList tagList) {
        TagUtil.getBaseTag(root).setTag("Materials", (NBTBase)tagList);
    }

    public static int getBaseModifiersUsed(NBTTagCompound root) {
        return TagUtil.getBaseTag(root).getInteger("UsedModifiers");
    }

    public static void setBaseModifiersUsed(NBTTagCompound root, int count) {
        TagUtil.getBaseTag(root).setInteger("UsedModifiers", count);
    }

    public static NBTTagCompound getToolTag(ItemStack stack) {
        return TagUtil.getToolTag(TagUtil.getTagSafe(stack));
    }

    public static NBTTagCompound getToolTag(NBTTagCompound root) {
        return TagUtil.getTagSafe(root, "Stats");
    }

    public static void setToolTag(ItemStack stack, NBTTagCompound tag) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setToolTag(root, tag);
        stack.setTagCompound(root);
    }

    public static void setToolTag(NBTTagCompound root, NBTTagCompound tag) {
        if (root != null) {
            root.setTag("Stats", (NBTBase)tag);
        }
    }

    public static NBTTagList getModifiersTagList(ItemStack stack) {
        return TagUtil.getModifiersTagList(TagUtil.getTagSafe(stack));
    }

    public static NBTTagList getModifiersTagList(NBTTagCompound root) {
        return TagUtil.getTagListSafe(root, "Modifiers", TAG_TYPE_COMPOUND);
    }

    public static void setModifiersTagList(ItemStack stack, NBTTagList tagList) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setModifiersTagList(root, tagList);
        stack.setTagCompound(root);
    }

    public static void setModifiersTagList(NBTTagCompound root, NBTTagList tagList) {
        if (root != null) {
            root.setTag("Modifiers", (NBTBase)tagList);
        }
    }

    public static NBTTagList getTraitsTagList(ItemStack stack) {
        return TagUtil.getTraitsTagList(TagUtil.getTagSafe(stack));
    }

    public static NBTTagList getTraitsTagList(NBTTagCompound root) {
        return TagUtil.getTagListSafe(root, "Traits", TAG_TYPE_STRING);
    }

    public static void setTraitsTagList(ItemStack stack, NBTTagList tagList) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setTraitsTagList(root, tagList);
        stack.setTagCompound(root);
    }

    public static void setTraitsTagList(NBTTagCompound root, NBTTagList tagList) {
        if (root != null) {
            root.setTag("Traits", (NBTBase)tagList);
        }
    }

    public static ToolNBT getToolStats(ItemStack stack) {
        return TagUtil.getToolStats(TagUtil.getTagSafe(stack));
    }

    public static ToolNBT getToolStats(NBTTagCompound root) {
        return new ToolNBT(TagUtil.getToolTag(root));
    }

    public static ToolNBT getOriginalToolStats(ItemStack stack) {
        return TagUtil.getOriginalToolStats(TagUtil.getTagSafe(stack));
    }

    public static ToolNBT getOriginalToolStats(NBTTagCompound root) {
        return new ToolNBT(TagUtil.getTagSafe(root, "StatsOriginal"));
    }

    public static NBTTagCompound getExtraTag(ItemStack stack) {
        return TagUtil.getExtraTag(TagUtil.getTagSafe(stack));
    }

    public static NBTTagCompound getExtraTag(NBTTagCompound root) {
        return TagUtil.getTagSafe(root, "Special");
    }

    public static void setExtraTag(ItemStack stack, NBTTagCompound tag) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setExtraTag(root, tag);
        stack.setTagCompound(root);
    }

    public static void setExtraTag(NBTTagCompound root, NBTTagCompound tag) {
        root.setTag("Special", (NBTBase)tag);
    }

    public static Category[] getCategories(NBTTagCompound root) {
        NBTTagList categories = TagUtil.getTagListSafe(TagUtil.getExtraTag(root), "Categories", 8);
        Category[] out = new Category[categories.tagCount()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = Category.categories.get(categories.getStringTagAt(i));
        }
        return out;
    }

    public static void setCategories(ItemStack stack, Category[] categories) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setCategories(root, categories);
        stack.setTagCompound(root);
    }

    public static void setCategories(NBTTagCompound root, Category[] categories) {
        NBTTagList list = new NBTTagList();
        for (Category category : categories) {
            list.appendTag((NBTBase)new NBTTagString(category.name));
        }
        NBTTagCompound extra = TagUtil.getExtraTag(root);
        extra.setTag("Categories", (NBTBase)list);
        TagUtil.setExtraTag(root, extra);
    }

    public static void setEnchantEffect(ItemStack stack, boolean active) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setEnchantEffect(root, active);
        stack.setTagCompound(root);
    }

    public static void setEnchantEffect(NBTTagCompound root, boolean active) {
        if (active) {
            root.setBoolean("EnchantEffect", true);
        } else {
            root.removeTag("EnchantEffect");
        }
    }

    public static boolean hasEnchantEffect(ItemStack stack) {
        return TagUtil.hasEnchantEffect(TagUtil.getTagSafe(stack));
    }

    public static boolean hasEnchantEffect(NBTTagCompound root) {
        return root.getBoolean("EnchantEffect");
    }

    public static NBTTagCompound writePos(BlockPos pos) {
        NBTTagCompound tag = new NBTTagCompound();
        if (pos != null) {
            tag.setInteger("X", pos.getX());
            tag.setInteger("Y", pos.getY());
            tag.setInteger("Z", pos.getZ());
        }
        return tag;
    }

    public static BlockPos readPos(NBTTagCompound tag) {
        if (tag != null) {
            return new BlockPos(tag.getInteger("X"), tag.getInteger("Y"), tag.getInteger("Z"));
        }
        return null;
    }

    public static void addInteger(NBTTagCompound tag, String key, int value) {
        tag.setInteger(key, tag.getInteger(key) + value);
    }

    public static void addFloat(NBTTagCompound tag, String key, float value) {
        tag.setFloat(key, tag.getFloat(key) + value);
    }

    public static NBTTagCompound combineTagsAverage(NBTTagCompound ... tags) {
        HashSet processedKeys = Sets.newHashSet();
        NBTTagCompound result = new NBTTagCompound();
        for (NBTTagCompound current : tags) {
            for (Object o : current.getKeySet()) {
                String key = (String)o;
                if (processedKeys.contains(key)) continue;
                processedKeys.add(key);
                switch (current.getTag(key).getId()) {
                    case 3: {
                        result.setInteger(key, TagUtil.averageIntTags(key, tags));
                        break;
                    }
                    case 5: {
                        result.setFloat(key, TagUtil.averageFloatTags(key, tags));
                        break;
                    }
                }
            }
        }
        return result;
    }

    private static int averageIntTags(String key, NBTTagCompound ... tags) {
        int count = 0;
        int total = 0;
        for (NBTTagCompound compound : tags) {
            if (!compound.hasKey(key)) continue;
            ++count;
            total += compound.getInteger(key);
        }
        return total / count;
    }

    private static float averageFloatTags(String key, NBTTagCompound ... tags) {
        int count = 0;
        float total = 0.0f;
        for (NBTTagCompound compound : tags) {
            if (!compound.hasKey(key)) continue;
            ++count;
            total += compound.getFloat(key);
        }
        return total / (float)count;
    }
}

