/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.TinkerAPIException;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.texture.TextureColoredTexture;

public class AnimatedColoredTexture
extends TextureColoredTexture {
    private TextureAtlasSprite actualTexture;

    public AnimatedColoredTexture(TextureAtlasSprite addTexture, TextureAtlasSprite baseTexture, String spriteName) {
        super(addTexture, baseTexture, spriteName);
    }

    @Override
    public boolean load(IResourceManager manager, ResourceLocation location) {
        this.actualTexture = this.addTexture.getFrameCount() > 0 ? this.addTexture : this.backupLoadtextureAtlasSprite(new ResourceLocation(this.addTextureLocation), Minecraft.getMinecraft().getResourceManager());
        return super.load(manager, location);
    }

    @Override
    protected void processData(int[][] data) {
        ResourceLocation resourcelocation1 = this.completeResourceLocation(new ResourceLocation(this.addTextureLocation), 0);
        IResource iresource = null;
        try {
            iresource = Minecraft.getMinecraft().getResourceManager().getResource(resourcelocation1);
        }
        catch (IOException e) {
            TinkerRegistry.log.error("Unable to load " + resourcelocation1, (Throwable)e);
            return;
        }
        AnimationMetadataSection meta = (AnimationMetadataSection)iresource.getMetadata("animation");
        if (meta == null) {
            throw new TinkerAPIException(String.format("Trying to create animated texture from %s but no animation data is present", this.addTextureLocation));
        }
        if (meta.getFrameCount() > 0) {
            for (Integer i1 : meta.getFrameIndexSet()) {
                if (this.framesTextureData.size() <= i1) {
                    for (int j = this.framesTextureData.size(); j <= i1; ++j) {
                        this.framesTextureData.add(null);
                    }
                }
                int[][] data2 = new int[data.length][];
                for (int j = 0; j < data.length; ++j) {
                    if (data[j] == null) continue;
                    data2[j] = (int[])data[j].clone();
                }
                this.textureData = this.actualTexture.getFrameTextureData(i1.intValue());
                super.processData(data2);
                this.framesTextureData.set(i1, data2);
            }
        } else {
            ArrayList frameList = Lists.newArrayList();
            int count = this.actualTexture.getFrameCount();
            for (int i = 0; i < count; ++i) {
                int[][] data2 = new int[data.length][];
                for (int j = 0; j < data.length; ++j) {
                    if (data[j] == null) continue;
                    data2[j] = (int[])data[j].clone();
                }
                this.textureData = this.actualTexture.getFrameTextureData(i);
                super.processData(data2);
                this.framesTextureData.add(i, data2);
                frameList.add(new AnimationFrame(i, -1));
            }
            meta = new AnimationMetadataSection((List)frameList, this.width, this.height, meta.getFrameTime(), meta.isInterpolate());
        }
        try {
            Field f = TextureAtlasSprite.class.getDeclaredField("animationMetadata");
            f.setAccessible(true);
            f.set((Object)this, meta);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }
}

