/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.model.BlockItemModelWrapper;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.tconstruct.library.Util;

@SideOnly(value=Side.CLIENT)
public class ItemBlockModelSetter {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBake(ModelBakeEvent event) {
        Map stateMap = event.modelManager.getBlockModelShapes().getBlockStateMapper().putAllStateModelLocations();
        for (ResourceLocation identifier : Item.itemRegistry.getKeys()) {
            Block block;
            Object o;
            if (!identifier.getResourceDomain().equals(Util.RESOURCE) || !((o = Item.itemRegistry.getObject((Object)identifier)) instanceof ItemBlockMeta)) continue;
            ItemBlockMeta item = (ItemBlockMeta)o;
            ModelResourceLocation loc = new ModelResourceLocation(identifier, "inventory");
            Object model = event.modelRegistry.getObject((Object)loc);
            if (model != null || (block = item.block) instanceof BlockSapling || block instanceof BlockVine || block instanceof BlockBush) continue;
            boolean first = true;
            for (int i = 0; i < 16; ++i) {
                ModelResourceLocation blockLoc;
                IBlockState state = block.getStateFromMeta(i);
                int meta = block.getMetaFromState(state);
                if (meta != i || (blockLoc = (ModelResourceLocation)stateMap.get(state)) == null) continue;
                IFlexibleBakedModel bakedBlockModel = (IFlexibleBakedModel)event.modelRegistry.getObject((Object)blockLoc);
                if (bakedBlockModel != null) {
                    bakedBlockModel = new BlockItemModelWrapper(bakedBlockModel);
                    if (first) {
                        event.modelRegistry.putObject((Object)loc, (Object)bakedBlockModel);
                        first = false;
                    }
                }
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)blockLoc);
            }
        }
    }
}

