/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerPulse;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerMaterials;

@Pulse(id="TinkerIntegration", forced=true)
public class TinkerIntegration
extends TinkerPulse {
    public static final String PulseId = "TinkerIntegration";
    static final Logger log = Util.getLogger("TinkerIntegration");
    public static List<MaterialIntegration> integrationList = Lists.newLinkedList();
    public static List<NBTTagList> alloys = Lists.newLinkedList();
    private MaterialIntegration alubrassIntegration = null;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        TinkerIntegration.integrate(TinkerMaterials.wood);
        TinkerIntegration.integrate(TinkerMaterials.stone);
        TinkerIntegration.integrate(TinkerMaterials.flint);
        TinkerIntegration.integrate(TinkerMaterials.cactus);
        TinkerIntegration.integrate(TinkerMaterials.bone);
        TinkerIntegration.integrate(TinkerMaterials.obsidian, TinkerFluids.obsidian);
        TinkerIntegration.integrate(TinkerMaterials.prismarine);
        TinkerIntegration.integrate(TinkerMaterials.endstone);
        TinkerIntegration.integrate(TinkerMaterials.paper);
        TinkerIntegration.integrate(TinkerMaterials.sponge);
        TinkerIntegration.integrate(TinkerMaterials.firewood);
        TinkerIntegration.integrate(TinkerMaterials.knightslime, TinkerFluids.knightslime, "Knightslime").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.slime, "slimecrystalGreen");
        TinkerIntegration.integrate(TinkerMaterials.blueslime, "slimecrystalBlue");
        TinkerIntegration.integrate(TinkerMaterials.magmaslime, "slimecrystalMagma");
        TinkerIntegration.integrate(TinkerMaterials.iron, TinkerFluids.iron, "Iron").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.pigiron, TinkerFluids.pigIron, "Pigiron").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.netherrack);
        TinkerIntegration.integrate(TinkerMaterials.cobalt, TinkerFluids.cobalt, "Cobalt").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.ardite, TinkerFluids.ardite, "Ardite").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.manyullyn, TinkerFluids.manyullyn, "Manyullyn").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.copper, TinkerFluids.copper, "Copper").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.bronze, TinkerFluids.bronze, "Bronze").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.lead, TinkerFluids.lead, "Lead").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.silver, TinkerFluids.silver, "Silver").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.electrum, TinkerFluids.electrum, "Electrum").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.steel, TinkerFluids.steel, "Steel").toolforge();
        TinkerIntegration.integrate(TinkerFluids.gold, "Gold").toolforge();
        TinkerIntegration.integrate(TinkerFluids.brass, "Brass").toolforge();
        TinkerIntegration.integrate(TinkerFluids.tin, "Tin").toolforge();
        TinkerIntegration.integrate(TinkerFluids.nickel, "Nickel").toolforge();
        TinkerIntegration.integrate(TinkerFluids.zinc, "Zinc").toolforge();
        TinkerIntegration.integrate(TinkerFluids.aluminum, "Aluminum").toolforge();
        for (MaterialIntegration integration : integrationList) {
            integration.integrate();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        this.handleIMCs();
        for (MaterialIntegration integration : integrationList) {
            integration.integrateRecipes();
        }
        this.handleAlloyIMCs();
    }

    @SubscribeEvent
    public void onOredictRegister(OreDictionary.OreRegisterEvent event) {
        if (Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            return;
        }
        for (MaterialIntegration integration : ImmutableList.copyOf(integrationList)) {
            integration.integrate();
        }
    }

    @SubscribeEvent
    public void onFluidRegister(FluidRegistry.FluidRegisterEvent event) {
        if (Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            return;
        }
        if (FluidRegistry.isFluidRegistered((Fluid)TinkerFluids.aluminum) && FluidRegistry.isFluidRegistered((Fluid)TinkerFluids.copper) && this.alubrassIntegration == null) {
            this.alubrassIntegration = TinkerIntegration.integrate(TinkerFluids.alubrass, "Alubrass").toolforge();
            this.alubrassIntegration.integrate();
            TinkerSmeltery.castCreationFluids.add(new FluidStack((Fluid)TinkerFluids.alubrass, 144));
        }
    }

    private void handleIMCs() {
        for (FMLInterModComms.IMCMessage message : FMLInterModComms.fetchRuntimeMessages((Object)TConstruct.instance)) {
            try {
                if (message.key.equals("integrateSmeltery")) {
                    NBTTagCompound tag = message.getNBTValue();
                    String fluidName = tag.getString("fluid");
                    String ore = tag.getString("ore");
                    boolean toolforge = tag.getBoolean("toolforge");
                    Fluid fluid = FluidRegistry.getFluid((String)fluidName);
                    if (fluid != null && ore != null && !ore.isEmpty()) {
                        boolean isNew = true;
                        for (MaterialIntegration mi : integrationList) {
                            if (mi.fluid == null || !mi.fluid.getName().equals(fluidName)) continue;
                            isNew = false;
                        }
                        if (isNew) {
                            MaterialIntegration materialIntegration = new MaterialIntegration(null, fluid, ore);
                            if (toolforge) {
                                materialIntegration.toolforge();
                            }
                            integrationList.add(materialIntegration);
                            materialIntegration.integrate();
                            log.info("Added integration smelting for " + ore + " from " + message.getSender());
                        }
                    }
                    if (!tag.hasKey("alloy")) continue;
                    alloys.add(tag.getTagList("alloy", 10));
                    continue;
                }
                if (message.key.equals("alloy")) {
                    alloys.add(message.getNBTValue().getTagList("alloy", 10));
                    continue;
                }
                if (!message.key.equals("blacklistMelting")) continue;
                if (message.getMessageType() == String.class) {
                    TinkerSmeltery.meltingBlacklist.addAll(OreDictionary.getOres((String)message.getStringValue(), (boolean)false));
                    continue;
                }
                TinkerSmeltery.meltingBlacklist.add(message.getItemStackValue());
            }
            catch (ClassCastException e) {
                log.error("Got invalid " + message.key + " IMC from " + message.getSender());
            }
        }
    }

    private void handleAlloyIMCs() {
        for (NBTTagList taglist : alloys) {
            LinkedList fluids = Lists.newLinkedList();
            for (int i = 0; i < taglist.tagCount(); ++i) {
                NBTTagCompound tag = taglist.getCompoundTagAt(i);
                FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                if (fs == null) {
                    fluids.clear();
                    break;
                }
                fluids.add(fs);
            }
            if (fluids.size() <= 2) continue;
            FluidStack output = (FluidStack)fluids.get(0);
            FluidStack[] input = new FluidStack[fluids.size() - 1];
            input = fluids.subList(1, fluids.size()).toArray(input);
            TinkerRegistry.registerAlloy(output, input);
            log.debug("Added integration alloy: " + output.getLocalizedName());
        }
    }

    public static MaterialIntegration integrate(Material material) {
        return TinkerIntegration.add(new MaterialIntegration(material));
    }

    public static MaterialIntegration integrate(Material material, Fluid fluid) {
        return TinkerIntegration.add(new MaterialIntegration(material, fluid));
    }

    public static MaterialIntegration integrate(Material material, String oreRequirement) {
        return TinkerIntegration.add(new MaterialIntegration(oreRequirement, material, null, null));
    }

    public static MaterialIntegration integrate(Material material, Fluid fluid, String oreSuffix) {
        return TinkerIntegration.add(new MaterialIntegration(material, fluid, oreSuffix));
    }

    public static MaterialIntegration integrate(Fluid fluid, String oreSuffix) {
        return TinkerIntegration.add(new MaterialIntegration(null, fluid, oreSuffix));
    }

    private static MaterialIntegration add(MaterialIntegration integration) {
        integrationList.add(integration);
        return integration;
    }
}

