/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.potion.TinkerPotion;
import slimeknights.tconstruct.library.traits.AbstractTrait;

public class TraitSharp
extends AbstractTrait {
    public static TinkerPotion DOT = new DoT();

    public TraitSharp() {
        super("sharp", 0xFFFFFF);
    }

    @Override
    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (wasHit && target.isEntityAlive()) {
            target.setLastAttacker((Entity)player);
            DOT.apply(target, 121);
        }
    }

    protected static void dealDamage(EntityLivingBase target, int level) {
        EntityLivingBase lastAttacker = target.getLastAttacker();
        Object source = lastAttacker != null ? new EntityDamageSource("bleed", (Entity)lastAttacker) : new DamageSource("bleed");
        int hurtResistantTime = target.hurtResistantTime;
        TraitSharp.attackEntitySecondary(source, ((float)level + 1.0f) / 3.0f, (Entity)target, true, true);
        target.hurtTime = hurtResistantTime;
    }

    public static class DoT
    extends TinkerPotion {
        public DoT() {
            super(Util.getResource("dot"), true, true);
        }

        public boolean isReady(int tick, int level) {
            return tick > 0 && tick % 15 == 0;
        }

        public void performEffect(EntityLivingBase target, int level) {
            TraitSharp.dealDamage(target, level);
        }
    }
}

