/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.tools.inventory.ContainerToolStation;

public class ToolStationTextPacket
extends AbstractPacketThreadsafe {
    public String text;

    public ToolStationTextPacket() {
    }

    public ToolStationTextPacket(String text) {
        this.text = text;
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        Container container = Minecraft.getMinecraft().thePlayer.openContainer;
        if (container instanceof ContainerToolStation) {
            ((ContainerToolStation)container).setToolName(this.text);
        }
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        Container container = netHandler.playerEntity.openContainer;
        if (container instanceof ContainerToolStation) {
            ((ContainerToolStation)container).setToolName(this.text);
            WorldServer server = netHandler.playerEntity.getServerForPlayer();
            for (EntityPlayer player : server.playerEntities) {
                if (!(player.openContainer instanceof ContainerToolStation) || !((ContainerToolStation)container).sameGui((BaseContainer)((ContainerToolStation)player.openContainer))) continue;
                TinkerNetwork.sendTo((AbstractPacket)this, (EntityPlayerMP)player);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
    }
}

