/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.debug;

import com.google.common.eventbus.Subscribe;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.debug.CompareVanilla;
import slimeknights.tconstruct.debug.DamageTool;
import slimeknights.tconstruct.debug.DumpMaterialTest;
import slimeknights.tconstruct.debug.FindBestTool;
import slimeknights.tconstruct.debug.GetToolGrowth;
import slimeknights.tconstruct.debug.LocalizationCheckCommand;
import slimeknights.tconstruct.debug.ReloadResources;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;

@Pulse(id="TinkerDebug", description="Debug utilities", defaultEnable=false)
public class TinkerDebug {
    public static final String PulseId = "TinkerDebug";
    static final Logger log = Util.getLogger("TinkerDebug");

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            ClientCommandHandler.instance.registerCommand((ICommand)new ReloadResources());
        }
    }

    @Subscribe
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new DamageTool());
        if (event.getSide().isClient()) {
            ClientCommandHandler.instance.registerCommand((ICommand)new LocalizationCheckCommand());
            ClientCommandHandler.instance.registerCommand((ICommand)new DumpMaterialTest());
            ClientCommandHandler.instance.registerCommand((ICommand)new FindBestTool());
            ClientCommandHandler.instance.registerCommand((ICommand)new GetToolGrowth());
            ClientCommandHandler.instance.registerCommand((ICommand)new CompareVanilla());
        }
        TinkerDebug.sanityCheck();
    }

    public static void sanityCheck() {
        int i;
        for (IModifier modifier : TinkerRegistry.getAllModifiers()) {
            try {
                modifier.matches(new ItemStack[]{new ItemStack(Items.stick)});
                modifier.matches(new ItemStack[1]);
            }
            catch (Exception e) {
                log.error("Caught exception in modifier " + modifier.getIdentifier());
                log.error((Object)e);
            }
        }
        for (ResourceLocation identifier : Block.blockRegistry.getKeys()) {
            if (!identifier.getResourceDomain().equals(Util.RESOURCE)) continue;
            Block block = (Block)Block.blockRegistry.getObject((Object)identifier);
            for (i = 0; i < 16; ++i) {
                block.getMetaFromState(block.getStateFromMeta(i));
            }
        }
        for (ResourceLocation identifier : Item.itemRegistry.getKeys()) {
            if (!identifier.getResourceDomain().equals(Util.RESOURCE)) continue;
            Item item = (Item)Item.itemRegistry.getObject((Object)identifier);
            for (i = 0; i < Short.MAX_VALUE; ++i) {
                item.getMetadata(i);
            }
        }
    }
}

