/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.debug;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.item.BroadSword;
import slimeknights.tconstruct.tools.item.Hatchet;
import slimeknights.tconstruct.tools.item.Pickaxe;
import slimeknights.tconstruct.tools.item.Shovel;

public class DumpMaterialTest
extends CommandBase {
    public static String path = "./dumps/";
    public Material baseMaterial = new Material("Baseline", EnumChatFormatting.WHITE);

    public DumpMaterialTest() {
        this.baseMaterial.addStats(new HeadMaterialStats(500, 10.0f, 10.0f, 1));
    }

    public int getRequiredPermissionLevel() {
        return 0;
    }

    public String getCommandName() {
        return "dumpMaterialTest";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "";
    }

    public void processCommand(ICommandSender sender, String[] args) throws CommandException {
        this.printStats();
        this.printTool(new Pickaxe(), this.baseMaterial);
        this.printTool(new Hatchet(), this.baseMaterial);
        this.printTool(new BroadSword(), this.baseMaterial);
        this.printTool(new Shovel(), this.baseMaterial);
        for (Material mat1 : TinkerRegistry.getAllMaterials()) {
            if (!mat1.hasStats("head")) continue;
            this.printTool(new Pickaxe(), mat1);
            this.printTool(new Hatchet(), mat1);
            this.printTool(new BroadSword(), mat1);
            this.printTool(new Shovel(), mat1);
        }
    }

    private void printStats() throws CommandException {
        File file = new File("dumps/materials.html");
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new CommandException(e.getMessage(), new Object[0]);
        }
        ArrayList header = Lists.newArrayList((Object[])new String[]{"Materials", "Durability", "Speed", "Attack", "Handle", "Extra"});
        ArrayList rows = Lists.newArrayList();
        for (Material mat1 : TinkerRegistry.getAllMaterials()) {
            if (!mat1.hasStats("head")) continue;
            HeadMaterialStats stats = (HeadMaterialStats)mat1.getStats("head");
            ArrayList row = Lists.newArrayList();
            rows.add(row);
            row.add("<td>" + mat1.getIdentifier() + "</td>");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("Materials");
        sb.append("</head>");
        sb.append("<body>");
        sb.append(DumpMaterialTest.array2HTML(header, rows, false));
        sb.append("</body>");
        sb.append("</html>");
        pw.print(sb.toString());
        pw.close();
    }

    private void printTool(ToolCore tool, Material head) throws CommandException {
        File file = new File("dumps/" + tool.getClass().getSimpleName() + "_" + head.getIdentifier() + ".html");
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new CommandException(e.getMessage(), new Object[0]);
        }
        DecimalFormat df = new DecimalFormat("#.00");
        HeadMaterialStats ref = (HeadMaterialStats)this.baseMaterial.getStats("head");
        ArrayList header = Lists.newArrayList();
        header.add("");
        ArrayList tableDur = Lists.newArrayList();
        ArrayList tableSpeed = Lists.newArrayList();
        ArrayList tableAttack = Lists.newArrayList();
        for (Material mat1 : TinkerRegistry.getAllMaterials()) {
            if (!mat1.hasStats("head")) continue;
            header.add(mat1.getIdentifier());
            ArrayList dur = Lists.newArrayList();
            tableDur.add(dur);
            ArrayList speed = Lists.newArrayList();
            tableSpeed.add(speed);
            ArrayList att = Lists.newArrayList();
            tableAttack.add(att);
            for (Material mat2 : TinkerRegistry.getAllMaterials()) {
                if (!mat2.hasStats("head")) continue;
                ItemStack stack = tool.buildItem((List<Material>)ImmutableList.of((Object)((Object)mat1), (Object)((Object)head), (Object)((Object)mat2)));
                int d = ToolHelper.getDurabilityStat(stack);
                String s = String.format("<td bgcolor=\"%s\">%s</td>", Integer.toHexString(this.floatToCol((float)d / (float)ref.durability)), String.valueOf(d));
                dur.add(s);
                float sp = ToolHelper.getMiningSpeedStat(stack);
                s = String.format("<td bgcolor=\"%s\">%s</td>", Integer.toHexString(this.floatToCol(sp / ref.miningspeed)), df.format(sp));
                speed.add(s);
                float at = ToolHelper.getAttackStat(stack) * tool.damagePotential();
                s = String.format("<td bgcolor=\"%s\">%s</td>", Integer.toHexString(this.floatToCol(at / ref.attack)), df.format(at));
                att.add(s);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<head>");
        sb.append(tool.getClass().getSimpleName());
        sb.append("</head>");
        sb.append("<body>");
        header.set(0, "Durability");
        sb.append(DumpMaterialTest.array2HTML(header, tableDur, true));
        sb.append("<hr>");
        header.set(0, "Speed");
        sb.append(DumpMaterialTest.array2HTML(header, tableSpeed, true));
        sb.append("<hr>");
        header.set(0, "Attack");
        sb.append(DumpMaterialTest.array2HTML(header, tableAttack, true));
        sb.append("</body>");
        sb.append("</html>");
        pw.print(sb.toString());
        pw.close();
    }

    private int floatToCol(float f) {
        return Color.HSBtoRGB(f / 3.0f, 0.65f, 0.8f) & 0xFFFFFF;
    }

    public static String array2HTML(List<String> header, List<List<String>> array, boolean headerAsRowCaption) {
        StringBuilder html = new StringBuilder("<table border=\"1\">");
        for (String elem : header) {
            html.append("<th>").append(elem.toString()).append("</th>");
        }
        for (int i = 0; i < array.size(); ++i) {
            List<String> row = array.get(i);
            html.append("<tr>");
            if (headerAsRowCaption) {
                html.append("<td>").append(header.get(i + 1)).append("</td>");
            }
            for (String elem : row) {
                html.append(elem.toString());
            }
            html.append("</tr>");
        }
        html.append("</table>");
        return html.toString();
    }
}

