/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.entity;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockLiquidSlime;
import slimeknights.tconstruct.world.TinkerWorld;

public class EntityBlueSlime
extends EntitySlime {
    public EntityBlueSlime(World worldIn) {
        super(worldIn);
    }

    public EntityItem dropItemWithOffset(Item itemIn, int size, float offsetY) {
        ItemStack stack = TinkerCommons.matSlimeBallBlue.copy();
        stack.stackSize = size;
        return this.entityDropItem(stack, offsetY);
    }

    protected EntitySlime createInstance() {
        return new EntityBlueSlime(this.worldObj);
    }

    public boolean getCanSpawnHere() {
        if (this.worldObj.getBlockState(this.getPosition()).getBlock() instanceof BlockLiquidSlime) {
            return true;
        }
        return this.worldObj.getBlockState(this.getPosition().down()).getBlock() == TinkerWorld.slimeGrass;
    }

    protected boolean spawnCustomParticles() {
        if (this.worldObj.isRemote) {
            int i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = this.rand.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.sin((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.cos((float)f) * (float)i * 0.5f * f1;
                double d0 = this.posX + (double)f2;
                double d1 = this.posZ + (double)f3;
                double d2 = this.getEntityBoundingBox().minY;
                TinkerWorld.proxy.spawnSlimeParticle(this.worldObj, d0, d2, d1);
            }
        }
        return true;
    }
}

