/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.mantle.tileentity.TileInventory;

public class InventoryUpdateSyncPacket
extends AbstractPacketThreadsafe {
    public ItemStack[] itemStacks;
    public BlockPos pos;

    public InventoryUpdateSyncPacket() {
    }

    public InventoryUpdateSyncPacket(ItemStack[] itemStacks, BlockPos pos) {
        this.itemStacks = itemStacks;
        this.pos = pos;
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        TileEntity tileEntity = Minecraft.getMinecraft().thePlayer.worldObj.getTileEntity(this.pos);
        if (tileEntity == null || !(tileEntity instanceof TileInventory)) {
            return;
        }
        TileInventory tile = (TileInventory)tileEntity;
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null) continue;
            tile.setInventorySlotContents(i, this.itemStacks[i]);
        }
        Minecraft.getMinecraft().renderGlobal.markBlockForUpdate(this.pos);
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        short size = buf.readShort();
        this.itemStacks = new ItemStack[size];
        int count = buf.readShort();
        for (int i = 0; i < count; ++i) {
            ItemStack stack;
            short index = buf.readShort();
            this.itemStacks[index] = stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        int i;
        this.writePos(this.pos, buf);
        buf.writeShort(this.itemStacks.length);
        int count = 0;
        for (i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null) continue;
            ++count;
        }
        buf.writeShort(count);
        for (i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null) continue;
            buf.writeShort(i);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStacks[i]);
        }
    }
}

