/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.client.model.ModifierModel;
import slimeknights.tconstruct.library.modifiers.IModifier;

public class ModifierModelLoader
implements ICustomModelLoader {
    public static String EXTENSION = ".mod";
    private static final String defaultName = "default";
    private static final Logger log = Util.getLogger("modifier");
    protected Map<String, List<ResourceLocation>> locations = Maps.newHashMap();
    protected Map<String, Map<String, String>> cache;

    public static ResourceLocation getLocationForToolModifiers(String toolName) {
        return new ResourceLocation(Util.RESOURCE, "modifiers/" + toolName + EXTENSION);
    }

    public void registerModifierFile(String modifier, ResourceLocation location) {
        LinkedList files = this.locations.get(modifier);
        if (files == null) {
            files = Lists.newLinkedList();
            this.locations.put(modifier, files);
        }
        files.add(location);
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110623_a().endsWith(EXTENSION);
    }

    public IModel loadModel(ResourceLocation modelLocation) {
        int start = modelLocation.func_110623_a().lastIndexOf(47);
        String toolname = modelLocation.func_110623_a().substring(start < 0 ? 0 : start + 1, modelLocation.func_110623_a().length() - EXTENSION.length());
        toolname = toolname.toLowerCase(Locale.US);
        if (this.cache == null) {
            this.cache = new THashMap();
            this.loadFilesIntoCache();
        }
        if (!this.cache.containsKey(toolname)) {
            return ModelLoaderRegistry.getMissingModel();
        }
        ModifierModel model = new ModifierModel();
        for (Map.Entry<String, String> entry : this.cache.get(toolname).entrySet()) {
            IModifier mod = TinkerRegistry.getModifier(entry.getKey());
            if (mod == null) {
                log.debug("Removing texture {} for modifier {}: No modifier present for texture", new Object[]{entry.getValue(), entry.getKey()});
                continue;
            }
            model.addModelForModifier(mod.getIdentifier(), entry.getValue());
            if (!mod.hasTexturePerMaterial()) continue;
            CustomTextureCreator.registerTexture(new ResourceLocation(entry.getValue()));
        }
        return model;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.cache = null;
    }

    private void loadFilesIntoCache() {
        this.cache.put(defaultName, (Map<String, String>)new THashMap());
        for (Map.Entry<String, List<ResourceLocation>> entry : this.locations.entrySet()) {
            String modifier = entry.getKey();
            List<ResourceLocation> modLocations = entry.getValue();
            for (ResourceLocation resourceLocation : modLocations) {
                try {
                    Map<String, String> textureEntries = ModelHelper.loadTexturesFromJson(resourceLocation);
                    for (Map.Entry<String, String> textureEntry : textureEntries.entrySet()) {
                        String tool = textureEntry.getKey().toLowerCase(Locale.US);
                        String texture = textureEntry.getValue();
                        if (!this.cache.containsKey(tool)) {
                            this.cache.put(tool, (Map<String, String>)new THashMap());
                        }
                        if (this.cache.get(tool).containsKey(modifier)) continue;
                        this.cache.get(tool).put(modifier, texture);
                    }
                }
                catch (IOException e) {
                    log.error("Cannot load modifier-model {}", new Object[]{entry.getValue()});
                }
                catch (JsonParseException e) {
                    log.error("Cannot load modifier-model {}", new Object[]{entry.getValue()});
                    throw e;
                }
            }
            if (this.cache.get(defaultName).containsKey(modifier)) continue;
            log.debug(String.format("%s Modifiers model does not contain a default-entry", modifier));
        }
        Map<String, String> defaults = this.cache.get(defaultName);
        for (Map.Entry<String, Map<String, String>> toolEntry : this.cache.entrySet()) {
            Map<String, String> textures = toolEntry.getValue();
            for (Map.Entry entry : defaults.entrySet()) {
                if (textures.containsKey(entry.getKey())) continue;
                log.debug("Filling in default for modifier {} on tool {}", new Object[]{entry.getKey(), toolEntry.getKey()});
                textures.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

