package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;

import net.minecraft.block.Block;
import net.minecraft.item.ItemSpade;
import net.minecraft.nbt.NBTTagCompound;

import java.util.List;

import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.tools.TinkerTools;

public class Shovel extends AoeToolCore {

  public static final ImmutableSet<net.minecraft.block.material.Material> effective_materials =
      ImmutableSet.of(net.minecraft.block.material.Material.field_151577_b,
                      net.minecraft.block.material.Material.field_151578_c,
                      net.minecraft.block.material.Material.field_151595_p,
                      net.minecraft.block.material.Material.field_151596_z,
                      net.minecraft.block.material.Material.field_151597_y,
                      net.minecraft.block.material.Material.field_151571_B,
                      net.minecraft.block.material.Material.field_151568_F);

  public Shovel() {
    this(PartMaterialType.handle(TinkerTools.toolRod),
         PartMaterialType.head(TinkerTools.shovelHead),
         PartMaterialType.extra(TinkerTools.binding));
  }

  protected Shovel(PartMaterialType... requiredComponents) {
    super(requiredComponents);

    addCategory(Category.HARVEST);

    setHarvestLevel("shovel", 0);
  }

  @Override
  public boolean isEffective(Block block) {
    return effective_materials.contains(block.func_149688_o()) || ItemSpade.field_150916_c.contains(block);
  }

  @Override
  public float damagePotential() {
    return 0.9f;
  }

  @Override
  public NBTTagCompound buildTag(List<Material> materials) {
    return buildDefaultTag(materials).get();
  }
}
