package slimeknights.tconstruct.tools.traits;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.shared.TinkerCommons;

public class TraitBaconlicious extends AbstractTrait {

  public TraitBaconlicious() {
    super("baconlicious", 0xffaaaa);
  }

  @Override
  public void afterBlockBreak(ItemStack tool, World world, Block block, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
    dropBacon(player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.005f);
  }

  @Override
  public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
    // did the target die?
    if(!target.func_70089_S() && wasHit) {
      dropBacon(target.field_70170_p, target.field_70165_t, target.field_70163_u, target.field_70161_v, 0.05f);
    }
  }

  protected void dropBacon(World world, double x, double y, double z, float chance) {
    if(!world.field_72995_K && random.nextFloat() < chance) {
      EntityItem entity = new EntityItem(world, x, y, z, TinkerCommons.bacon.func_77946_l());
      world.func_72838_d(entity);
    }
  }
}
