package slimeknights.tconstruct.tools.client.module;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;

import java.io.IOException;

import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.client.gui.GuiMultiModule;

/**
 * A grid of buttons that allows you to select one of them
 */
public class GuiSideButtons extends GuiModule {

  private final int columns;
  private GuiButton clickedButton;

  public int spacing = 4;

  public GuiSideButtons(GuiMultiModule parent, Container container, int columns) {
    this(parent, container, columns, false);
  }

  public GuiSideButtons(GuiMultiModule parent, Container container, int columns, boolean right) {
    super(parent, container, right, false);
    this.columns = columns;
  }

  public void addButton(GuiButton button) {
    int count = field_146292_n.size();

    int rows = (count-1)/columns + 1;

    this.field_146999_f = button.field_146120_f*columns + spacing * (columns-1);
    this.field_147000_g = button.field_146121_g * rows + spacing * (rows - 1);

    int offset = field_146292_n.size();
    int x = (offset % columns) * (button.field_146120_f + spacing);
    int y = (offset / columns) * (button.field_146121_g + spacing);

    button.field_146128_h = field_147003_i + x;
    button.field_146129_i = field_147009_r + y;

    if(this.right) {
      button.field_146128_h += parent.field_146999_f;
    }

    this.field_146292_n.add(button);
  }

  @Override
  public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException{
    if (mouseButton == 0)
    {
      for(Object o : this.field_146292_n) {
        GuiButton guibutton = (GuiButton) o;

        if(guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
          this.clickedButton = guibutton;
          guibutton.func_146113_a(this.field_146297_k.func_147118_V());
          this.func_146284_a(guibutton);
          return true;
        }
      }
    }

    return false;
  }

  @Override
  public boolean handleMouseReleased(int mouseX, int mouseY, int state) {
    if(clickedButton != null) {
      clickedButton.func_146118_a(mouseX, mouseY);
      clickedButton = null;
      return true;
    }
    return false;
  }

  @Override
  protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    for(Object o : field_146292_n) {
      ((GuiButton)o).func_146112_a(this.field_146297_k, mouseX, mouseY);
    }
  }
}
